package com.github.shoothzj.javatool.constant;

import lombok.extern.slf4j.Slf4j;

/**
 * @author hezhangjian
 */
@Slf4j
public class EnvConstant {

  /**
   * 用户路径
   * e.g. Mac: /Users/akka
   */
  public static final String userHome = System.getProperty("user.home");

  /**
   * 操作系统名称
   * e.g. Mac: Mac OS X
   */
  public static final String osName = System.getProperty("os.name");

  /**
   * os的版本
   * e.g. 10.15.2
   */
  public static final String osVersion = System.getProperty("os.version");

  private EnvConstant() {

  }

  public static void listAll() {
    log.info("userHome is {}", userHome);
    log.info("osName is {}", osName);
    log.info("osVersion is {}", osVersion);
  }
  
}
