/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.api;

import java.util.List;
import java.util.Map;
import shiver.me.timbers.webservice.stub.api.Stringify;
import shiver.me.timbers.webservice.stub.api.StubHeaders;
import shiver.me.timbers.webservice.stub.api.StubMessage;
import shiver.me.timbers.webservice.stub.api.StubQuery;

public abstract class StubRequest<T, R extends StubRequest>
extends StubMessage<T, R> {
    private String method;
    private String path;
    private StubQuery query;

    protected StubRequest(Stringify stringify) {
        super(stringify, new StubHeaders(), null);
        this.method = "GET";
        this.path = "";
        this.query = new StubQuery();
    }

    protected StubRequest(Stringify stringify, T body) {
        this(stringify);
        this.method = "POST";
        this.setBody(body);
    }

    protected StubRequest(StubRequest<T, R> request) {
        super(request);
        this.method = request.getMethod();
        this.path = request.getPath();
        this.query = request.getQuery();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public R withMethod(String method) {
        this.method = method;
        return (R)this;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public R withPath(String path) {
        this.path = path;
        return (R)this;
    }

    public StubQuery getQuery() {
        return this.query;
    }

    public void setQuery(StubQuery query) {
        this.query = query;
    }

    public R withQuery(String query) {
        return this.withQuery(StubQuery.parse(query));
    }

    public R withQuery(Map.Entry<String, List<String>> ... params) {
        return this.withQuery(new StubQuery(params));
    }

    public R withQuery(StubQuery query) {
        this.query = query;
        return (R)this;
    }

    public String toString() {
        return "StubRequest{, method='" + this.method + '\'' + ", path='" + this.path + '\'' + ", query=" + this.query + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + '}';
    }
}

