/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.api;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shiver.me.timbers.webservice.stub.api.Stringify;
import shiver.me.timbers.webservice.stub.api.StubContentType;
import shiver.me.timbers.webservice.stub.api.StubHeaders;

public abstract class StubMessage<T, R extends StubMessage> {
    private final Stringify stringify;
    private StubHeaders headers;
    private T body;

    protected StubMessage(StubMessage<T, R> request) {
        this(request.stringify, request.getHeaders(), request.getBody());
    }

    public StubMessage(Stringify stringify, StubHeaders headers, T body) {
        this.stringify = stringify;
        this.headers = headers;
        this.body = body;
    }

    public StubHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(StubHeaders headers) {
        this.headers = headers;
    }

    public R withHeaders(Map.Entry<String, List<String>> ... headers) {
        return this.withHeaders(new StubHeaders(headers));
    }

    public R withHeaders(Set<Map.Entry<String, List<String>>> headers) {
        return this.withHeaders(new StubHeaders((Collection<Map.Entry<String, List<String>>>)headers));
    }

    public R withHeaders(Map<String, List<String>> headers) {
        return this.withHeaders(new StubHeaders(headers));
    }

    public R withHeaders(StubHeaders headers) {
        this.headers.putAll(headers);
        return (R)this;
    }

    public StubContentType getContentType() {
        List contentType = (List)((Map.Entry)this.headers.entrySet().stream().filter(this::isContentType).findFirst().orElse(new AbstractMap.SimpleEntry<Object, Object>(null, null))).getValue();
        return contentType != null ? new StubContentType(contentType) : null;
    }

    private boolean isContentType(Map.Entry<String, List<String>> entry) {
        return "content-type".equals(entry.getKey().toLowerCase());
    }

    public T getBody() {
        return this.body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public R withBody(T body) {
        this.body = body;
        return (R)this;
    }

    public String stringifyBody() {
        return this.stringify.toString(this.body);
    }

    public abstract R copy();
}

