/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.api;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import shiver.me.timbers.webservice.stub.api.MimeTypes;

public class StubContentType
extends AbstractMap.SimpleEntry<String, List<String>> {
    public static final String CONTENT_TYPE = "content-type";
    private final MimeTypes mimeTypes;

    public StubContentType(String value) {
        this(Collections.singletonList(value));
    }

    public StubContentType(List<String> value) {
        this(MimeTypes.mimeTypes(), value);
    }

    public StubContentType(MimeTypes mimeTypes, List<String> values) {
        super(CONTENT_TYPE, values);
        this.mimeTypes = mimeTypes;
    }

    public boolean isXml() {
        return ((List)this.getValue()).stream().anyMatch(this::isXml);
    }

    public boolean isJson() {
        return ((List)this.getValue()).stream().anyMatch(this::isJson);
    }

    private boolean isXml(String mimeType) {
        return this.isSubType(mimeType, "xml");
    }

    private boolean isJson(String mimeType) {
        return this.isSubType(mimeType, "json");
    }

    private boolean isSubType(String mimeType, String subType) {
        return this.mimeTypes.containsSubType(mimeType, subType);
    }
}

