/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.api;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class MultiValueTreeMap<K extends Comparable, V>
extends TreeMap<K, List<V>> {
    @SafeVarargs
    public static <K extends Comparable, V> Map.Entry<K, List<V>> e(K key, V ... values) {
        return MultiValueTreeMap.e(key, Arrays.asList(values));
    }

    public static <K extends Comparable, V> Map.Entry<K, List<V>> e(K name, List<V> values) {
        return new AbstractMap.SimpleEntry<K, List<V>>(name, values);
    }

    public static <K extends Comparable, V> MultiValueTreeMap<K, V> toMultiTreeMap(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return new MultiValueTreeMap<Comparable, V>(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList(entry.getValue()))));
    }

    public MultiValueTreeMap() {
    }

    @SafeVarargs
    public MultiValueTreeMap(Map.Entry<K, List<V>> ... entries) {
        this(entries == null ? null : Arrays.asList(entries));
    }

    public MultiValueTreeMap(Collection<Map.Entry<K, List<V>>> entries) {
        this(MultiValueTreeMap.toMultiTreeMap(entries));
    }

    public MultiValueTreeMap(Map<K, List<V>> map) {
        super(map == null ? Collections.emptyMap() : map);
    }

    @Override
    public List<V> put(K key, V ... values) {
        return super.put(key, Arrays.asList(values));
    }

    public void add(K key, V ... values) {
        this.add(key, Arrays.asList(values));
    }

    public void add(K key, List<V> values) {
        List list = (List)this.get(key);
        if (list == null) {
            this.put(key, new ArrayList<V>(values));
            return;
        }
        list.addAll(values);
    }

    private static <K extends Comparable, V> Map<K, List<V>> toMultiTreeMap(Collection<Map.Entry<K, List<V>>> values) {
        if (values == null) {
            return null;
        }
        MultiValueTreeMap map = new MultiValueTreeMap();
        values.forEach((? super T entry) -> map.add((Object)((Comparable)entry.getKey()), (List)entry.getValue()));
        return map;
    }
}

