/*
 * Decompiled with CFR 0.152.
 */
package com.github.shawven.security.oauth2;

import com.github.shawven.security.oauth2.JwtTokenEnhancer;
import com.github.shawven.security.oauth2.OAuth2Properties;
import com.github.shawven.security.oauth2.Oauth2JwtProperties;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.security.oauth2.provider.token.store.KeyStoreKeyFactory;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;

@Configuration
public class TokenStoreConfiguration {

    @Configuration
    @ConditionalOnProperty(prefix="app.security.oauth2", name={"token-store"}, havingValue="jwt", matchIfMissing=true)
    public static class JwtConfig
    implements ApplicationContextAware {
        private ApplicationContext context;
        private Oauth2JwtProperties jwt;

        public JwtConfig(OAuth2Properties properties) {
            this.jwt = properties.getJwt();
        }

        public void setApplicationContext(ApplicationContext context) throws BeansException {
            this.context = context;
        }

        @Bean
        @ConditionalOnMissingBean
        public TokenStore jwtTokenStore(JwtAccessTokenConverter jwtAccessTokenConverter) {
            return new JwtTokenStore(jwtAccessTokenConverter);
        }

        @Bean
        @ConditionalOnProperty(prefix="app.security.oauth2.jwt", name={"key-store"})
        @ConditionalOnMissingBean
        public JwtAccessTokenConverter jwtKeyStoreAccessTokenConverter() {
            Objects.requireNonNull(this.jwt.getKeyStore(), "keyStore cannot be null");
            Objects.requireNonNull(this.jwt.getKeyStorePassword(), "keyStorePassword cannot be null");
            Objects.requireNonNull(this.jwt.getKeyAlias(), "keyAlias cannot be null");
            Resource keyStore = this.context.getResource(this.jwt.getKeyStore());
            char[] keyStorePassword = this.jwt.getKeyStorePassword().toCharArray();
            KeyStoreKeyFactory keyStoreKeyFactory = new KeyStoreKeyFactory(keyStore, keyStorePassword);
            char[] keyPassword = Optional.ofNullable(this.jwt.getKeyPassword()).map(String::toCharArray).orElse(keyStorePassword);
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            converter.setKeyPair(keyStoreKeyFactory.getKeyPair(this.jwt.getKeyAlias(), keyPassword));
            return converter;
        }

        @Bean
        @ConditionalOnProperty(prefix="app.security.oauth2.jwt", name={"key-store"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public JwtAccessTokenConverter jwtSigningKeyAccessTokenConverter() {
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            Objects.requireNonNull(this.jwt.getSigningKey(), "SigningKey cannot be null");
            converter.setSigningKey(this.jwt.getSigningKey());
            return converter;
        }

        @Bean
        @ConditionalOnBean(value={TokenEnhancer.class})
        @ConditionalOnMissingBean
        public TokenEnhancer jwtTokenEnhancer() {
            return new JwtTokenEnhancer();
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisConnectionFactory.class})
    @ConditionalOnProperty(prefix="app.security.oauth2", name={"token-store"}, havingValue="redis")
    public static class RedisConfig {
        private RedisConnectionFactory redisConnectionFactory;

        public RedisConfig(RedisConnectionFactory redisConnectionFactory) {
            this.redisConnectionFactory = redisConnectionFactory;
        }

        @Bean
        @ConditionalOnMissingBean
        public TokenStore redisTokenStore() {
            return new RedisTokenStore(this.redisConnectionFactory);
        }
    }
}

