/*
 * Decompiled with CFR 0.152.
 */
package com.github.shawven.security.oauth2;

import com.github.shawven.security.oauth2.AuthenticationSuccessHandlerPostProcessor;
import com.github.shawven.security.oauth2.OAuth2AuthenticationSuccessHandler;
import com.github.shawven.security.oauth2.OAuth2Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

@Configuration
@EnableConfigurationProperties(value={OAuth2Properties.class})
public class OAuth2AutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AuthenticationSuccessHandler authenticationSuccessHandler(ClientDetailsService clientDetailsService, PasswordEncoder passwordEncoder, AuthorizationServerTokenServices services, @Autowired(required=false) AuthenticationSuccessHandlerPostProcessor authenticationSuccessHandlerPostProcessor) {
        OAuth2AuthenticationSuccessHandler handler = new OAuth2AuthenticationSuccessHandler(clientDetailsService, passwordEncoder, services);
        if (authenticationSuccessHandlerPostProcessor != null) {
            authenticationSuccessHandlerPostProcessor.postProcess(handler);
        }
        return handler;
    }

    @Configuration
    @ConditionalOnMissingBean(value={PasswordEncoder.class})
    public static class BaseConfiguration {
        @Bean
        public PasswordEncoder passwordEncoder() {
            return new BCryptPasswordEncoder();
        }
    }
}

