/*
 * Decompiled with CFR 0.152.
 */
package com.github.shawven.security.oauth2;

import com.github.shawven.security.oauth2.ClientCredentialsTokenEndpointFilterPostProcessor;
import com.github.shawven.security.oauth2.OAuth2ClientProperties;
import com.github.shawven.security.oauth2.OAuth2Properties;
import com.github.shawven.security.oauth2.TokenStoreConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.builders.InMemoryClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@EnableAuthorizationServer
@AutoConfigureAfter(value={TokenStoreConfiguration.class})
public class AuthorizationServerConfiguration
extends AuthorizationServerConfigurerAdapter {
    private UserDetailsService userDetailsService;
    private AuthenticationManager authenticationManager;
    private TokenStore tokenStore;
    private OAuth2Properties properties;
    private PasswordEncoder passwordEncoder;
    private AccessDeniedHandler accessDeniedHandler;
    private AuthenticationEntryPoint authenticationEntryPoint;
    private JwtAccessTokenConverter jwtAccessTokenConverter;
    private TokenEnhancer jwtTokenEnhancer;

    public AuthorizationServerConfiguration(UserDetailsService userDetailsService, AuthenticationManager authenticationManager, TokenStore tokenStore, OAuth2Properties properties, PasswordEncoder passwordEncoder, AccessDeniedHandler accessDeniedHandler, AuthenticationEntryPoint authenticationEntryPoint, @Autowired(required=false) JwtAccessTokenConverter jwtAccessTokenConverter, @Autowired(required=false) TokenEnhancer jwtTokenEnhancer) {
        this.userDetailsService = userDetailsService;
        this.authenticationManager = authenticationManager;
        this.tokenStore = tokenStore;
        this.properties = properties;
        this.passwordEncoder = passwordEncoder;
        this.accessDeniedHandler = accessDeniedHandler;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.jwtAccessTokenConverter = jwtAccessTokenConverter;
        this.jwtTokenEnhancer = jwtTokenEnhancer;
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        endpoints.tokenStore(this.tokenStore).authenticationManager(this.authenticationManager).userDetailsService(this.userDetailsService);
        if (this.jwtAccessTokenConverter != null && this.jwtTokenEnhancer != null) {
            TokenEnhancerChain enhancerChain = new TokenEnhancerChain();
            ArrayList<Object> enhancers = new ArrayList<Object>();
            enhancers.add(this.jwtTokenEnhancer);
            enhancers.add(this.jwtAccessTokenConverter);
            enhancerChain.setTokenEnhancers(enhancers);
            endpoints.tokenEnhancer((TokenEnhancer)enhancerChain).accessTokenConverter((AccessTokenConverter)this.jwtAccessTokenConverter);
        }
    }

    public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
        security.allowFormAuthenticationForClients().passwordEncoder(this.passwordEncoder).addObjectPostProcessor((ObjectPostProcessor)new ClientCredentialsTokenEndpointFilterPostProcessor(this.authenticationEntryPoint));
        security.tokenKeyAccess("isAuthenticated()").checkTokenAccess("isAuthenticated()").accessDeniedHandler(this.accessDeniedHandler).authenticationEntryPoint(this.authenticationEntryPoint);
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        InMemoryClientDetailsServiceBuilder builder = clients.inMemory();
        List<OAuth2ClientProperties> userClients = this.properties.getClients();
        if (userClients.isEmpty()) {
            return;
        }
        for (OAuth2ClientProperties client : userClients) {
            if (client == null) continue;
            builder.withClient(client.getClientId()).secret(this.passwordEncoder.encode((CharSequence)client.getClientSecret())).authorizedGrantTypes(new String[]{"password", "authorization_code", "refresh_token", "client_credentials"}).accessTokenValiditySeconds(client.getAccessTokenValidateSeconds()).refreshTokenValiditySeconds(client.getRefreshTokenValidateSeconds()).autoApprove(true).scopes(new String[]{"all"});
        }
    }
}

