/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.http;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.http.UserAgent;
import notion.api.v1.logging.NotionLogger;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B%\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J@\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0013H\u0016JH\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0017\u001a\u00020\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JH\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0017\u001a\u00020\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnotion/api/v1/http/OkHttp5Client;", "Lnotion/api/v1/http/NotionHttpClient;", "()V", "connectTimeoutMillis", "", "writeTimeoutMillis", "readTimeoutMillis", "(III)V", "client", "Lokhttp3/OkHttpClient;", "close", "", "delete", "Lnotion/api/v1/http/NotionHttpResponse;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "url", "", "query", "", "headers", "get", "patchTextBody", "body", "perform", "req", "Lokhttp3/Request$Builder;", "postTextBody", "Companion", "UserAgentInterceptor", "notion-sdk-jvm-okhttp5"})
public final class OkHttp5Client
implements NotionHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.Companion.get("application/json; charset=utf-8");
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 3000;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 30000;
    private static final int DEFAULT_WRITE_TIMEOUT_MILLIS = 30000;

    public OkHttp5Client() {
        this.client = notion.api.v1.http.OkHttp5Client$Companion.buildOkHttpClient$default(Companion, 0, 0, 0, 7, null);
    }

    public OkHttp5Client(int connectTimeoutMillis, int writeTimeoutMillis, int readTimeoutMillis) {
        this.client = Companion.buildOkHttpClient(connectTimeoutMillis, writeTimeoutMillis, readTimeoutMillis);
    }

    public /* synthetic */ OkHttp5Client(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 3000;
        }
        if ((n4 & 2) != 0) {
            n2 = 30000;
        }
        if ((n4 & 4) != 0) {
            n3 = 30000;
        }
        this(n, n2, n3);
    }

    @NotNull
    public NotionHttpResponse get(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, String> query, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String fullUrl = this.buildFullUrl(url, this.buildQueryString(query));
        Request.Builder req = new Request.Builder().url(fullUrl).get();
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$name$value = element$iv = iterator.next();
            boolean bl = false;
            String name = $dstr$name$value.getKey();
            String value = $dstr$name$value.getValue();
            req.header(name, value);
        }
        return this.perform(req, "", logger);
    }

    @NotNull
    public NotionHttpResponse postTextBody(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, String> query, @NotNull String body, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String fullUrl = this.buildFullUrl(url, this.buildQueryString(query));
        Request.Builder req = new Request.Builder().url(fullUrl).post(RequestBody.Companion.create(body, MEDIA_TYPE_APPLICATION_JSON));
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$name$value = element$iv = iterator.next();
            boolean bl = false;
            String name = $dstr$name$value.getKey();
            String value = $dstr$name$value.getValue();
            req.header(name, value);
        }
        return this.perform(req, body, logger);
    }

    @NotNull
    public NotionHttpResponse patchTextBody(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, String> query, @NotNull String body, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String fullUrl = this.buildFullUrl(url, this.buildQueryString(query));
        Request.Builder req = new Request.Builder().url(fullUrl).patch(RequestBody.Companion.create(body, MEDIA_TYPE_APPLICATION_JSON));
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$name$value = element$iv = iterator.next();
            boolean bl = false;
            String name = $dstr$name$value.getKey();
            String value = $dstr$name$value.getValue();
            req.header(name, value);
        }
        return this.perform(req, body, logger);
    }

    @NotNull
    public NotionHttpResponse delete(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, String> query, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String fullUrl = this.buildFullUrl(url, this.buildQueryString(query));
        Request.Builder req = Request.Builder.delete$default((Request.Builder)new Request.Builder().url(fullUrl), null, (int)1, null);
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$name$value = element$iv = iterator.next();
            boolean bl = false;
            String name = $dstr$name$value.getKey();
            String value = $dstr$name$value.getValue();
            req.header(name, value);
        }
        return this.perform(req, "", logger);
    }

    public void close() throws Exception {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
        Cache cache = this.client.cache();
        if (cache != null) {
            cache.close();
        }
    }

    private final NotionHttpResponse perform(Request.Builder req, String body, NotionLogger logger) {
        long startTimeMillis = System.currentTimeMillis();
        Request request = req.build();
        String string = request.method();
        String string2 = request.url().url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.url.toUrl().toString()");
        this.debugLogStart(logger, string, string2, body);
        Response resp = this.client.newCall(req.build()).execute();
        try {
            String string3;
            int n = resp.code();
            Map map = resp.headers().toMultimap();
            ResponseBody responseBody = resp.body();
            if (responseBody == null) {
                string3 = "";
            } else {
                string3 = responseBody.string();
                if (string3 == null) {
                    string3 = "";
                }
            }
            String string4 = string3;
            NotionHttpResponse response = new NotionHttpResponse(n, string4, map);
            this.debugLogSuccess(logger, startTimeMillis, response);
            return response;
        }
        catch (Exception e) {
            this.warnLogFailure(logger, e);
            throw e;
        }
    }

    @NotNull
    public String buildFullUrl(@NotNull String url, @NotNull String q) {
        return NotionHttpClient.DefaultImpls.buildFullUrl((NotionHttpClient)this, (String)url, (String)q);
    }

    @NotNull
    public String buildQueryString(@NotNull Map<String, String> query) {
        return NotionHttpClient.DefaultImpls.buildQueryString((NotionHttpClient)this, query);
    }

    public void debugLogStart(@NotNull NotionLogger logger, @NotNull String method, @NotNull String fullUrl, @Nullable String body) {
        NotionHttpClient.DefaultImpls.debugLogStart((NotionHttpClient)this, (NotionLogger)logger, (String)method, (String)fullUrl, (String)body);
    }

    public void debugLogSuccess(@NotNull NotionLogger logger, long startTimeMillis, @NotNull NotionHttpResponse response) {
        NotionHttpClient.DefaultImpls.debugLogSuccess((NotionHttpClient)this, (NotionLogger)logger, (long)startTimeMillis, (NotionHttpResponse)response);
    }

    @NotNull
    public String urlEncode(@NotNull String value) {
        return NotionHttpClient.DefaultImpls.urlEncode((NotionHttpClient)this, (String)value);
    }

    public void warnLogFailure(@NotNull NotionLogger logger, @NotNull Exception e) {
        NotionHttpClient.DefaultImpls.warnLogFailure((NotionHttpClient)this, (NotionLogger)logger, (Exception)e);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnotion/api/v1/http/OkHttp5Client$Companion;", "", "()V", "DEFAULT_CONNECT_TIMEOUT_MILLIS", "", "DEFAULT_READ_TIMEOUT_MILLIS", "DEFAULT_WRITE_TIMEOUT_MILLIS", "MEDIA_TYPE_APPLICATION_JSON", "Lokhttp3/MediaType;", "buildOkHttpClient", "Lokhttp3/OkHttpClient;", "connectTimeoutMillis", "writeTimeoutMillis", "readTimeoutMillis", "notion-sdk-jvm-okhttp5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OkHttpClient buildOkHttpClient(int connectTimeoutMillis, int writeTimeoutMillis, int readTimeoutMillis) {
            OkHttpClient.Builder client = new OkHttpClient.Builder();
            client.addInterceptor((Interceptor)UserAgentInterceptor.INSTANCE);
            client.connectTimeout((long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
            client.writeTimeout((long)writeTimeoutMillis, TimeUnit.MILLISECONDS);
            client.readTimeout((long)readTimeoutMillis, TimeUnit.MILLISECONDS);
            return client.build();
        }

        public static /* synthetic */ OkHttpClient buildOkHttpClient$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = 3000;
            }
            if ((n4 & 2) != 0) {
                n2 = 3000;
            }
            if ((n4 & 4) != 0) {
                n3 = 3000;
            }
            return companion.buildOkHttpClient(n, n2, n3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnotion/api/v1/http/OkHttp5Client$UserAgentInterceptor;", "Lokhttp3/Interceptor;", "()V", "userAgent", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "notion-sdk-jvm-okhttp5"})
    public static final class UserAgentInterceptor
    implements Interceptor {
        @NotNull
        public static final UserAgentInterceptor INSTANCE = new UserAgentInterceptor();
        @NotNull
        private static final String userAgent = UserAgent.buildUserAgent();

        private UserAgentInterceptor() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Request request = chain.request().newBuilder().header("User-Agent", userAgent).build();
            return chain.proceed(request);
        }
    }
}

