/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.endpoint.EndpointsSupport;
import notion.api.v1.exception.NotionAPIError;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.json.NotionJsonSerializer;
import notion.api.v1.logging.NotionLogger;
import notion.api.v1.model.search.SearchResults;
import notion.api.v1.request.search.SearchRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lnotion/api/v1/endpoint/SearchSupport;", "Lnotion/api/v1/endpoint/EndpointsSupport;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "httpClient", "Lnotion/api/v1/http/NotionHttpClient;", "getHttpClient", "()Lnotion/api/v1/http/NotionHttpClient;", "jsonSerializer", "Lnotion/api/v1/json/NotionJsonSerializer;", "getJsonSerializer", "()Lnotion/api/v1/json/NotionJsonSerializer;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "getLogger", "()Lnotion/api/v1/logging/NotionLogger;", "search", "Lnotion/api/v1/model/search/SearchResults;", "query", "request", "Lnotion/api/v1/request/search/SearchRequest;", "notion-sdk-jvm-core"})
public interface SearchSupport
extends EndpointsSupport {
    @NotNull
    public NotionHttpClient getHttpClient();

    @NotNull
    public NotionJsonSerializer getJsonSerializer();

    @NotNull
    public NotionLogger getLogger();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public SearchResults search(@NotNull String var1);

    @NotNull
    public SearchResults search(@NotNull SearchRequest var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static SearchResults search(@NotNull SearchSupport this_, @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return this_.search(new SearchRequest(query));
        }

        @NotNull
        public static SearchResults search(@NotNull SearchSupport this_, @NotNull SearchRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.postTextBody$default(this_.getHttpClient(), this_.getLogger(), Intrinsics.stringPlus((String)this_.getBaseUrl(), (Object)"/search"), null, this_.getJsonSerializer().toJsonString(request), this_.buildRequestHeaders(this_.contentTypeJson()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toSearchResults(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse);
        }

        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull SearchSupport this_, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            return EndpointsSupport.DefaultImpls.buildRequestHeaders(this_, additionalOnes);
        }

        @NotNull
        public static Map<String, String> contentTypeJson(@NotNull SearchSupport this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return EndpointsSupport.DefaultImpls.contentTypeJson(this_);
        }

        @NotNull
        public static String urlEncode(@NotNull SearchSupport this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return EndpointsSupport.DefaultImpls.urlEncode(this_, value);
        }
    }
}

