/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.net.URLEncoder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.http.UserAgent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J(\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007H\u0016J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"Lnotion/api/v1/endpoint/EndpointsSupport;", "", "token", "", "getToken", "()Ljava/lang/String;", "buildRequestHeaders", "", "additionalOnes", "contentTypeJson", "urlEncode", "value", "notion-sdk-jvm-core"})
public interface EndpointsSupport {
    @NotNull
    public String getToken();

    @NotNull
    public Map<String, String> buildRequestHeaders(@NotNull Map<String, String> var1);

    @NotNull
    public String urlEncode(@NotNull String var1);

    @NotNull
    public Map<String, String> contentTypeJson();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull EndpointsSupport this_, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"Authorization", (Object)Intrinsics.stringPlus((String)"Bearer ", (Object)this_.getToken()));
            pairArray[1] = TuplesKt.to((Object)"Notion-Version", (Object)"2021-05-13");
            pairArray[2] = TuplesKt.to((Object)"User-Agent", (Object)UserAgent.INSTANCE.buildUserAgent());
            return MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), additionalOnes);
        }

        @NotNull
        public static String urlEncode(@NotNull EndpointsSupport this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = URLEncoder.encode(value, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(value, \"UTF-8\")");
            return string;
        }

        @NotNull
        public static Map<String, String> contentTypeJson(@NotNull EndpointsSupport this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json; charset=utf-8"));
        }
    }
}

