/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.endpoint.EndpointsSupport;
import notion.api.v1.exception.NotionAPIError;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.json.NotionJsonSerializer;
import notion.api.v1.logging.NotionLogger;
import notion.api.v1.model.blocks.Block;
import notion.api.v1.model.blocks.Blocks;
import notion.api.v1.request.blocks.AppendBlockChildrenRequest;
import notion.api.v1.request.blocks.RetrieveBlockChildrenRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0018H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lnotion/api/v1/endpoint/BlocksSupport;", "Lnotion/api/v1/endpoint/EndpointsSupport;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "httpClient", "Lnotion/api/v1/http/NotionHttpClient;", "getHttpClient", "()Lnotion/api/v1/http/NotionHttpClient;", "jsonSerializer", "Lnotion/api/v1/json/NotionJsonSerializer;", "getJsonSerializer", "()Lnotion/api/v1/json/NotionJsonSerializer;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "getLogger", "()Lnotion/api/v1/logging/NotionLogger;", "appendBlockChildren", "Lnotion/api/v1/model/blocks/Block;", "request", "Lnotion/api/v1/request/blocks/AppendBlockChildrenRequest;", "retrieveBlockChildren", "Lnotion/api/v1/model/blocks/Blocks;", "Lnotion/api/v1/request/blocks/RetrieveBlockChildrenRequest;", "notion-sdk-jvm-core"})
public interface BlocksSupport
extends EndpointsSupport {
    @NotNull
    public NotionHttpClient getHttpClient();

    @NotNull
    public NotionJsonSerializer getJsonSerializer();

    @NotNull
    public NotionLogger getLogger();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public Blocks retrieveBlockChildren(@NotNull RetrieveBlockChildrenRequest var1);

    @NotNull
    public Block appendBlockChildren(@NotNull AppendBlockChildrenRequest var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Blocks retrieveBlockChildren(@NotNull BlocksSupport this_, @NotNull RetrieveBlockChildrenRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionLogger notionLogger = this_.getLogger();
            Map<String, String> map = request.toQuery();
            String string = this_.getBaseUrl() + "/blocks/" + this_.urlEncode(request.getBlockId()) + "/children";
            Map<String, String> map2 = this_.buildRequestHeaders(MapsKt.emptyMap());
            NotionHttpResponse httpResponse = this_.getHttpClient().get(notionLogger, string, map, map2);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toBlocks(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse);
        }

        @NotNull
        public static Block appendBlockChildren(@NotNull BlocksSupport this_, @NotNull AppendBlockChildrenRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.patchTextBody$default(this_.getHttpClient(), this_.getLogger(), this_.getBaseUrl() + "/pages/" + request.getBlockId() + "/children", null, this_.getJsonSerializer().toJsonString(request), this_.buildRequestHeaders(this_.contentTypeJson()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toBlock(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse);
        }

        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull BlocksSupport this_, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            return EndpointsSupport.DefaultImpls.buildRequestHeaders(this_, additionalOnes);
        }

        @NotNull
        public static Map<String, String> contentTypeJson(@NotNull BlocksSupport this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return EndpointsSupport.DefaultImpls.contentTypeJson(this_);
        }

        @NotNull
        public static String urlEncode(@NotNull BlocksSupport this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return EndpointsSupport.DefaultImpls.urlEncode(this_, value);
        }
    }
}

