/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.logging.NotionLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lnotion/api/v1/logging/JavaUtilLogger;", "Lnotion/api/v1/logging/NotionLogger;", "()V", "logger", "Ljava/util/logging/Logger;", "(Ljava/util/logging/Logger;)V", "getLogger", "()Ljava/util/logging/Logger;", "debug", "", "message", "", "e", "", "error", "info", "isDebugEnabled", "", "warn", "notion-sdk-jvm-core"})
public final class JavaUtilLogger
implements NotionLogger {
    @NotNull
    private final Logger logger;

    public JavaUtilLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public JavaUtilLogger() {
        Logger logger = Logger.getLogger(JavaUtilLogger.class.getCanonicalName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(JavaUtilLogger::class.java.canonicalName)");
        this(logger);
        if (this.logger.getLevel() == null) {
            this.logger.setLevel(Level.ALL);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.log(Level.FINE, message, e);
    }

    @Override
    public void info(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.log(Level.INFO, message, e);
    }

    @Override
    public void warn(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.log(Level.WARNING, message, e);
    }

    @Override
    public void error(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.log(Level.SEVERE, message, e);
    }

    @Override
    public void debug(@NotNull String message) {
        NotionLogger.DefaultImpls.debug(this, message);
    }

    @Override
    public void error(@NotNull String message) {
        NotionLogger.DefaultImpls.error(this, message);
    }

    @Override
    public void info(@NotNull String message) {
        NotionLogger.DefaultImpls.info(this, message);
    }

    @Override
    public void warn(@NotNull String message) {
        NotionLogger.DefaultImpls.warn(this, message);
    }
}

