/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.http;

import java.io.Closeable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.logging.NotionLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u001c\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016JB\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tH&JJ\u0010\u0019\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tH&JJ\u0010\u001a\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tH&J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u001c\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0016\u00a8\u0006!"}, d2={"Lnotion/api/v1/http/NotionHttpClient;", "Ljava/lang/AutoCloseable;", "Ljava/io/Closeable;", "buildFullUrl", "", "url", "q", "buildQueryString", "query", "", "close", "", "debugLogStart", "logger", "Lnotion/api/v1/logging/NotionLogger;", "method", "fullUrl", "body", "debugLogSuccess", "startTimeMillis", "", "response", "Lnotion/api/v1/http/NotionHttpResponse;", "get", "headers", "patchTextBody", "postTextBody", "urlEncode", "value", "warnLogFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "notion-sdk-jvm-core"})
public interface NotionHttpClient
extends AutoCloseable,
Closeable {
    @NotNull
    public NotionHttpResponse get(@NotNull NotionLogger var1, @NotNull String var2, @NotNull Map<String, String> var3, @NotNull Map<String, String> var4);

    @NotNull
    public NotionHttpResponse postTextBody(@NotNull NotionLogger var1, @NotNull String var2, @NotNull Map<String, String> var3, @NotNull String var4, @NotNull Map<String, String> var5);

    @NotNull
    public NotionHttpResponse patchTextBody(@NotNull NotionLogger var1, @NotNull String var2, @NotNull Map<String, String> var3, @NotNull String var4, @NotNull Map<String, String> var5);

    @Override
    public void close();

    @NotNull
    public String urlEncode(@NotNull String var1);

    @NotNull
    public String buildQueryString(@NotNull Map<String, String> var1);

    @NotNull
    public String buildFullUrl(@NotNull String var1, @NotNull String var2);

    public void debugLogStart(@NotNull NotionLogger var1, @NotNull String var2, @NotNull String var3, @Nullable String var4);

    public void debugLogSuccess(@NotNull NotionLogger var1, long var2, @NotNull NotionHttpResponse var4);

    public void warnLogFailure(@NotNull NotionLogger var1, @NotNull Exception var2);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ NotionHttpResponse get$default(NotionHttpClient notionHttpClient, NotionLogger notionLogger, String string, Map map, Map map2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
            }
            if ((n & 4) != 0) {
                map = MapsKt.emptyMap();
            }
            return notionHttpClient.get(notionLogger, string, map, map2);
        }

        public static /* synthetic */ NotionHttpResponse postTextBody$default(NotionHttpClient notionHttpClient, NotionLogger notionLogger, String string, Map map, String string2, Map map2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postTextBody");
            }
            if ((n & 4) != 0) {
                map = MapsKt.emptyMap();
            }
            return notionHttpClient.postTextBody(notionLogger, string, map, string2, map2);
        }

        public static /* synthetic */ NotionHttpResponse patchTextBody$default(NotionHttpClient notionHttpClient, NotionLogger notionLogger, String string, Map map, String string2, Map map2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: patchTextBody");
            }
            if ((n & 4) != 0) {
                map = MapsKt.emptyMap();
            }
            return notionHttpClient.patchTextBody(notionLogger, string, map, string2, map2);
        }

        public static void close(@NotNull NotionHttpClient this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
        }

        @NotNull
        public static String urlEncode(@NotNull NotionHttpClient this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = URLEncoder.encode(value, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(value, \"UTF-8\")");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static String buildQueryString(@NotNull NotionHttpClient this_, @NotNull Map<String, String> query) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Map<String, String> $this$map$iv = query;
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this_.urlEncode((String)it.getKey()) + '=' + this_.urlEncode((String)it.getValue()));
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null);
        }

        @NotNull
        public static String buildFullUrl(@NotNull NotionHttpClient this_, @NotNull String url, @NotNull String q) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return Intrinsics.stringPlus((String)url, (Object)(!Intrinsics.areEqual((Object)q, (Object)"?") ? q : ""));
        }

        public static void debugLogStart(@NotNull NotionHttpClient this_, @NotNull NotionLogger logger, @NotNull String method, @NotNull String fullUrl, @Nullable String body) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)fullUrl, (String)"fullUrl");
            if (logger.isDebugEnabled()) {
                String b = body == null || ((CharSequence)body).length() == 0 ? "" : "body   " + body + '\n';
                logger.debug(StringsKt.trimMargin$default((String)StringsKt.trimIndent((String)("Sending a request:\n" + method + ' ' + fullUrl + '\n' + b + '\n')), null, (int)1, null));
            }
        }

        public static void debugLogSuccess(@NotNull NotionHttpClient this_, @NotNull NotionLogger logger, long startTimeMillis, @NotNull NotionHttpResponse response) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (logger.isDebugEnabled()) {
                long responseTimeMillis = System.currentTimeMillis() - startTimeMillis;
                logger.debug(StringsKt.trimMargin$default((String)StringsKt.trimIndent((String)("Received a response (" + responseTimeMillis + " millis):\nstatus  " + response.getStatus() + "\nbody    " + response.getBody() + '\n')), null, (int)1, null));
            }
        }

        public static void warnLogFailure(@NotNull NotionHttpClient this_, @NotNull NotionLogger logger, @NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            logger.warn(Intrinsics.stringPlus((String)"Failed to disconnect from Notion: ", (Object)e.getMessage()), e);
        }
    }
}

