/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.http;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import notion.api.v1.http.HttpUrlConnPatchMethodWorkaround;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.logging.NotionLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J@\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bH\u0016JH\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0018\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bH\u0016JH\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0018\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u0012\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnotion/api/v1/http/HttpUrlConnNotionHttpClient;", "Lnotion/api/v1/http/NotionHttpClient;", "connectTimeoutMillis", "", "readTimeoutMillis", "(II)V", "buildConnectionObject", "Ljava/net/HttpURLConnection;", "fullUrl", "", "headers", "", "connect", "Ljava/io/InputStream;", "conn", "disconnect", "", "logger", "Lnotion/api/v1/logging/NotionLogger;", "get", "Lnotion/api/v1/http/NotionHttpResponse;", "url", "query", "patchTextBody", "body", "postTextBody", "readResponseBody", "input", "setRequestBody", "notion-sdk-jvm-core"})
public final class HttpUrlConnNotionHttpClient
implements NotionHttpClient {
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;

    @JvmOverloads
    public HttpUrlConnNotionHttpClient(int connectTimeoutMillis, int readTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public /* synthetic */ HttpUrlConnNotionHttpClient(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 3000;
        }
        if ((n3 & 2) != 0) {
            n2 = 30000;
        }
        this(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public NotionHttpResponse get(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, String> query, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        long startTimeMillis = System.currentTimeMillis();
        String q = this.buildQueryString(query);
        String fullUrl = this.buildFullUrl(url, q);
        HttpURLConnection conn = this.buildConnectionObject(fullUrl, headers);
        try {
            NotionHttpResponse notionHttpResponse;
            conn.setRequestMethod("GET");
            Object object = conn.getRequestMethod();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"conn.requestMethod");
            this.debugLogStart(logger, (String)object, fullUrl, null);
            object = this.connect(conn);
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)object;
                boolean bl = false;
                int n = conn.getResponseCode();
                String string = this.readResponseBody(input);
                Map<String, List<String>> map = conn.getHeaderFields();
                Intrinsics.checkNotNullExpressionValue(map, (String)"conn.headerFields");
                NotionHttpResponse response = new NotionHttpResponse(n, string, map);
                this.debugLogSuccess(logger, startTimeMillis, response);
                notionHttpResponse = response;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            NotionHttpResponse notionHttpResponse2 = notionHttpResponse;
            return notionHttpResponse2;
        }
        finally {
            this.disconnect(conn, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public NotionHttpResponse postTextBody(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, String> query, @NotNull String body, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        long startTimeMillis = System.currentTimeMillis();
        String q = this.buildQueryString(query);
        String fullUrl = this.buildFullUrl(url, q);
        HttpURLConnection conn = this.buildConnectionObject(fullUrl, headers);
        try {
            NotionHttpResponse notionHttpResponse;
            conn.setRequestMethod("POST");
            Object object = conn.getRequestMethod();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"conn.requestMethod");
            this.debugLogStart(logger, (String)object, fullUrl, body);
            this.setRequestBody(conn, body);
            object = this.connect(conn);
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)object;
                boolean bl = false;
                int n = conn.getResponseCode();
                String string = this.readResponseBody(input);
                Map<String, List<String>> map = conn.getHeaderFields();
                Intrinsics.checkNotNullExpressionValue(map, (String)"conn.headerFields");
                NotionHttpResponse response = new NotionHttpResponse(n, string, map);
                this.debugLogSuccess(logger, startTimeMillis, response);
                notionHttpResponse = response;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            NotionHttpResponse notionHttpResponse2 = notionHttpResponse;
            return notionHttpResponse2;
        }
        finally {
            this.disconnect(conn, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public NotionHttpResponse patchTextBody(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, String> query, @NotNull String body, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        long startTimeMillis = System.currentTimeMillis();
        String q = this.buildQueryString(query);
        String fullUrl = this.buildFullUrl(url, q);
        HttpURLConnection conn = this.buildConnectionObject(fullUrl, headers);
        try {
            NotionHttpResponse notionHttpResponse;
            HttpUrlConnPatchMethodWorkaround.INSTANCE.setPatchRequestMethod(conn);
            Object object = conn.getRequestMethod();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"conn.requestMethod");
            this.debugLogStart(logger, (String)object, fullUrl, body);
            this.setRequestBody(conn, body);
            object = this.connect(conn);
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)object;
                boolean bl = false;
                int n = conn.getResponseCode();
                String string = this.readResponseBody(input);
                Map<String, List<String>> map = conn.getHeaderFields();
                Intrinsics.checkNotNullExpressionValue(map, (String)"conn.headerFields");
                NotionHttpResponse response = new NotionHttpResponse(n, string, map);
                this.debugLogSuccess(logger, startTimeMillis, response);
                notionHttpResponse = response;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            NotionHttpResponse notionHttpResponse2 = notionHttpResponse;
            return notionHttpResponse2;
        }
        finally {
            this.disconnect(conn, logger);
        }
    }

    private final HttpURLConnection buildConnectionObject(String fullUrl, Map<String, String> headers) {
        URLConnection uRLConnection = new URL(fullUrl).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        conn.setRequestProperty("Connection", "close");
        conn.setConnectTimeout(this.connectTimeoutMillis);
        conn.setReadTimeout(this.readTimeoutMillis);
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$name$value = element$iv = iterator.next();
            boolean bl = false;
            String name = $dstr$name$value.getKey();
            String value = $dstr$name$value.getValue();
            conn.setRequestProperty(name, value);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setRequestBody(HttpURLConnection conn, String body) {
        conn.setDoOutput(true);
        Closeable closeable = conn.getOutputStream();
        Throwable throwable = null;
        try {
            OutputStream out = (OutputStream)closeable;
            boolean bl = false;
            byte[] byArray = body.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            out.write(byArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final InputStream connect(HttpURLConnection conn) {
        InputStream inputStream;
        try {
            conn.connect();
            inputStream = conn.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"{\n        conn.connect()\u2026 conn.inputStream\n      }");
        }
        catch (IOException e) {
            InputStream inputStream2 = conn.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"{\n        conn.errorStream\n      }");
            inputStream = inputStream2;
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readResponseBody(InputStream input) {
        String string;
        BufferedReader bufferedReader;
        Closeable closeable = input;
        if (closeable == null) {
            bufferedReader = null;
        } else {
            Closeable closeable2 = closeable;
            closeable2 = new InputStreamReader((InputStream)closeable2, Charsets.UTF_8);
            int n = 8192;
            bufferedReader = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
        }
        closeable = bufferedReader;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            BufferedReader bufferedReader2 = it;
            String string2 = bufferedReader2 == null ? null : TextStreamsKt.readText((Reader)bufferedReader2);
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string3 = string;
        if (string == null) {
            string3 = "";
        }
        return string3;
    }

    private final void disconnect(HttpURLConnection conn, NotionLogger logger) {
        try {
            conn.disconnect();
        }
        catch (Exception e) {
            this.warnLogFailure(logger, e);
        }
    }

    @Override
    public void close() {
        NotionHttpClient.DefaultImpls.close(this);
    }

    @Override
    @NotNull
    public String urlEncode(@NotNull String value) {
        return NotionHttpClient.DefaultImpls.urlEncode(this, value);
    }

    @Override
    @NotNull
    public String buildQueryString(@NotNull Map<String, String> query) {
        return NotionHttpClient.DefaultImpls.buildQueryString(this, query);
    }

    @Override
    @NotNull
    public String buildFullUrl(@NotNull String url, @NotNull String q) {
        return NotionHttpClient.DefaultImpls.buildFullUrl(this, url, q);
    }

    @Override
    public void debugLogStart(@NotNull NotionLogger logger, @NotNull String method, @NotNull String fullUrl, @Nullable String body) {
        NotionHttpClient.DefaultImpls.debugLogStart(this, logger, method, fullUrl, body);
    }

    @Override
    public void debugLogSuccess(@NotNull NotionLogger logger, long startTimeMillis, @NotNull NotionHttpResponse response) {
        NotionHttpClient.DefaultImpls.debugLogSuccess(this, logger, startTimeMillis, response);
    }

    @Override
    public void warnLogFailure(@NotNull NotionLogger logger, @NotNull Exception e) {
        NotionHttpClient.DefaultImpls.warnLogFailure(this, logger, e);
    }

    @JvmOverloads
    public HttpUrlConnNotionHttpClient(int connectTimeoutMillis) {
        this(connectTimeoutMillis, 0, 2, null);
    }

    @JvmOverloads
    public HttpUrlConnNotionHttpClient() {
        this(0, 0, 3, null);
    }
}

