/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.endpoint.EndpointsSupport;
import notion.api.v1.exception.NotionAPIError;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.json.NotionJsonSerializer;
import notion.api.v1.logging.NotionLogger;
import notion.api.v1.model.common.Cover;
import notion.api.v1.model.common.Icon;
import notion.api.v1.model.databases.Database;
import notion.api.v1.model.databases.DatabaseParent;
import notion.api.v1.model.databases.DatabaseProperty;
import notion.api.v1.model.databases.DatabasePropertySchema;
import notion.api.v1.model.databases.Databases;
import notion.api.v1.model.databases.QueryResults;
import notion.api.v1.model.databases.query.filter.QueryTopLevelFilter;
import notion.api.v1.model.databases.query.sort.QuerySort;
import notion.api.v1.request.databases.CreateDatabaseRequest;
import notion.api.v1.request.databases.ListDatabasesRequest;
import notion.api.v1.request.databases.QueryDatabaseRequest;
import notion.api.v1.request.databases.RetrieveDatabaseRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001JJ\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001b0\u001a2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J%\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0016JK\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00032\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\u0010\b\u0002\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010\u00172\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u00101J\u0010\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0010\u00103\u001a\u00020\u00132\u0006\u0010(\u001a\u000204H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00065"}, d2={"Lnotion/api/v1/endpoint/DatabasesSupport;", "Lnotion/api/v1/endpoint/EndpointsSupport;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "httpClient", "Lnotion/api/v1/http/NotionHttpClient;", "getHttpClient", "()Lnotion/api/v1/http/NotionHttpClient;", "jsonSerializer", "Lnotion/api/v1/json/NotionJsonSerializer;", "getJsonSerializer", "()Lnotion/api/v1/json/NotionJsonSerializer;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "getLogger", "()Lnotion/api/v1/logging/NotionLogger;", "createDatabase", "Lnotion/api/v1/model/databases/Database;", "parent", "Lnotion/api/v1/model/databases/DatabaseParent;", "title", "", "Lnotion/api/v1/model/databases/DatabaseProperty$RichText;", "properties", "", "Lnotion/api/v1/model/databases/DatabasePropertySchema;", "icon", "Lnotion/api/v1/model/common/Icon;", "cover", "Lnotion/api/v1/model/common/Cover;", "database", "Lnotion/api/v1/request/databases/CreateDatabaseRequest;", "listDatabases", "Lnotion/api/v1/model/databases/Databases;", "pageSize", "", "startCursor", "(Ljava/lang/Integer;Ljava/lang/String;)Lnotion/api/v1/model/databases/Databases;", "request", "Lnotion/api/v1/request/databases/ListDatabasesRequest;", "queryDatabase", "Lnotion/api/v1/model/databases/QueryResults;", "databaseId", "filter", "Lnotion/api/v1/model/databases/query/filter/QueryTopLevelFilter;", "sorts", "Lnotion/api/v1/model/databases/query/sort/QuerySort;", "(Ljava/lang/String;Lnotion/api/v1/model/databases/query/filter/QueryTopLevelFilter;Ljava/util/List;Ljava/lang/String;Ljava/lang/Integer;)Lnotion/api/v1/model/databases/QueryResults;", "Lnotion/api/v1/request/databases/QueryDatabaseRequest;", "retrieveDatabase", "Lnotion/api/v1/request/databases/RetrieveDatabaseRequest;", "notion-sdk-jvm-core"})
public interface DatabasesSupport
extends EndpointsSupport {
    @NotNull
    public NotionHttpClient getHttpClient();

    @NotNull
    public NotionJsonSerializer getJsonSerializer();

    @NotNull
    public NotionLogger getLogger();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public Database createDatabase(@NotNull DatabaseParent var1, @NotNull List<? extends DatabaseProperty.RichText> var2, @NotNull Map<String, ? extends DatabasePropertySchema> var3, @Nullable Icon var4, @Nullable Cover var5);

    @NotNull
    public Database createDatabase(@NotNull CreateDatabaseRequest var1);

    @NotNull
    public Databases listDatabases();

    @NotNull
    public Databases listDatabases(@Nullable Integer var1, @Nullable String var2);

    @NotNull
    public Databases listDatabases(@NotNull ListDatabasesRequest var1);

    @NotNull
    public Database retrieveDatabase(@NotNull String var1);

    @NotNull
    public Database retrieveDatabase(@NotNull RetrieveDatabaseRequest var1);

    @NotNull
    public QueryResults queryDatabase(@NotNull String var1, @Nullable QueryTopLevelFilter var2, @Nullable List<? extends QuerySort> var3, @Nullable String var4, @Nullable Integer var5);

    @NotNull
    public QueryResults queryDatabase(@NotNull QueryDatabaseRequest var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Database createDatabase(@NotNull DatabasesSupport this_, @NotNull DatabaseParent parent, @NotNull List<? extends DatabaseProperty.RichText> title, @NotNull Map<String, ? extends DatabasePropertySchema> properties, @Nullable Icon icon, @Nullable Cover cover) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter(title, (String)"title");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            return this_.createDatabase(new CreateDatabaseRequest(parent, title, properties, icon, cover));
        }

        public static /* synthetic */ Database createDatabase$default(DatabasesSupport databasesSupport, DatabaseParent databaseParent, List list, Map map, Icon icon, Cover cover, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createDatabase");
            }
            if ((n & 8) != 0) {
                icon = null;
            }
            if ((n & 0x10) != 0) {
                cover = null;
            }
            return databasesSupport.createDatabase(databaseParent, list, map, icon, cover);
        }

        @NotNull
        public static Database createDatabase(@NotNull DatabasesSupport this_, @NotNull CreateDatabaseRequest database) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.postTextBody$default(this_.getHttpClient(), this_.getLogger(), Intrinsics.stringPlus((String)this_.getBaseUrl(), (Object)"/databases"), null, this_.getJsonSerializer().toJsonString(database), this_.buildRequestHeaders(this_.contentTypeJson()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toDatabase(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Databases listDatabases(@NotNull DatabasesSupport this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.listDatabases(new ListDatabasesRequest(null, null, 3, null));
        }

        @NotNull
        public static Databases listDatabases(@NotNull DatabasesSupport this_, @Nullable Integer pageSize, @Nullable String startCursor) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.listDatabases(new ListDatabasesRequest(startCursor, pageSize));
        }

        public static /* synthetic */ Databases listDatabases$default(DatabasesSupport databasesSupport, Integer n, String string, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: listDatabases");
            }
            if ((n2 & 1) != 0) {
                n = null;
            }
            if ((n2 & 2) != 0) {
                string = null;
            }
            return databasesSupport.listDatabases(n, string);
        }

        @NotNull
        public static Databases listDatabases(@NotNull DatabasesSupport this_, @NotNull ListDatabasesRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = this_.getHttpClient().get(this_.getLogger(), Intrinsics.stringPlus((String)this_.getBaseUrl(), (Object)"/databases"), request.buildPaginationParams(), this_.buildRequestHeaders(MapsKt.emptyMap()));
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toDatabases(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Database retrieveDatabase(@NotNull DatabasesSupport this_, @NotNull String databaseId) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
            return this_.retrieveDatabase(new RetrieveDatabaseRequest(databaseId));
        }

        @NotNull
        public static Database retrieveDatabase(@NotNull DatabasesSupport this_, @NotNull RetrieveDatabaseRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.get$default(this_.getHttpClient(), this_.getLogger(), this_.getBaseUrl() + "/databases/" + this_.urlEncode(request.getDatabaseId()), null, this_.buildRequestHeaders(MapsKt.emptyMap()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toDatabase(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static QueryResults queryDatabase(@NotNull DatabasesSupport this_, @NotNull String databaseId, @Nullable QueryTopLevelFilter filter, @Nullable List<? extends QuerySort> sorts, @Nullable String startCursor, @Nullable Integer pageSize) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
            return this_.queryDatabase(new QueryDatabaseRequest(databaseId, filter, sorts, startCursor, pageSize));
        }

        public static /* synthetic */ QueryResults queryDatabase$default(DatabasesSupport databasesSupport, String string, QueryTopLevelFilter queryTopLevelFilter, List list, String string2, Integer n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queryDatabase");
            }
            if ((n2 & 2) != 0) {
                queryTopLevelFilter = null;
            }
            if ((n2 & 4) != 0) {
                list = null;
            }
            if ((n2 & 8) != 0) {
                string2 = null;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            return databasesSupport.queryDatabase(string, queryTopLevelFilter, list, string2, n);
        }

        @NotNull
        public static QueryResults queryDatabase(@NotNull DatabasesSupport this_, @NotNull QueryDatabaseRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.postTextBody$default(this_.getHttpClient(), this_.getLogger(), this_.getBaseUrl() + "/databases/" + this_.urlEncode(request.getDatabaseId()) + "/query", null, this_.getJsonSerializer().toJsonString(request), this_.buildRequestHeaders(this_.contentTypeJson()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toQueryResults(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull DatabasesSupport this_, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            return EndpointsSupport.DefaultImpls.buildRequestHeaders(this_, additionalOnes);
        }

        @NotNull
        public static String urlEncode(@NotNull DatabasesSupport this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return EndpointsSupport.DefaultImpls.urlEncode(this_, value);
        }

        @NotNull
        public static Map<String, String> contentTypeJson(@NotNull DatabasesSupport this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return EndpointsSupport.DefaultImpls.contentTypeJson(this_);
        }
    }
}

