/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.endpoint.EndpointsSupport;
import notion.api.v1.exception.NotionAPIError;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.json.NotionJsonSerializer;
import notion.api.v1.logging.NotionLogger;
import notion.api.v1.model.pages.Page;
import notion.api.v1.request.pages.CreatePageRequest;
import notion.api.v1.request.pages.RetrievePageRequest;
import notion.api.v1.request.pages.UpdatePagePropertiesRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u001bH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lnotion/api/v1/endpoint/PagesSupport;", "Lnotion/api/v1/endpoint/EndpointsSupport;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "httpClient", "Lnotion/api/v1/http/NotionHttpClient;", "getHttpClient", "()Lnotion/api/v1/http/NotionHttpClient;", "jsonSerializer", "Lnotion/api/v1/json/NotionJsonSerializer;", "getJsonSerializer", "()Lnotion/api/v1/json/NotionJsonSerializer;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "getLogger", "()Lnotion/api/v1/logging/NotionLogger;", "createPage", "Lnotion/api/v1/model/pages/Page;", "page", "Lnotion/api/v1/request/pages/CreatePageRequest;", "retrievePage", "pageId", "request", "Lnotion/api/v1/request/pages/RetrievePageRequest;", "updatePageProperties", "Lnotion/api/v1/request/pages/UpdatePagePropertiesRequest;", "notion-sdk-jvm-core"})
public interface PagesSupport
extends EndpointsSupport {
    @NotNull
    public NotionHttpClient getHttpClient();

    @NotNull
    public NotionJsonSerializer getJsonSerializer();

    @NotNull
    public NotionLogger getLogger();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public Page createPage(@NotNull CreatePageRequest var1);

    @NotNull
    public Page retrievePage(@NotNull String var1);

    @NotNull
    public Page retrievePage(@NotNull RetrievePageRequest var1);

    @NotNull
    public Page updatePageProperties(@NotNull UpdatePagePropertiesRequest var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Page createPage(@NotNull PagesSupport this_, @NotNull CreatePageRequest page) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.postTextBody$default(this_.getHttpClient(), this_.getLogger(), Intrinsics.stringPlus((String)this_.getBaseUrl(), (Object)"/pages"), null, this_.getJsonSerializer().toJsonString(page), this_.buildRequestHeaders(MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json"))), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toPage(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Page retrievePage(@NotNull PagesSupport this_, @NotNull String pageId) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
            return this_.retrievePage(new RetrievePageRequest(pageId));
        }

        @NotNull
        public static Page retrievePage(@NotNull PagesSupport this_, @NotNull RetrievePageRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.get$default(this_.getHttpClient(), this_.getLogger(), this_.getBaseUrl() + "/pages/" + this_.urlEncode(request.getPageId()), null, this_.buildRequestHeaders(MapsKt.emptyMap()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toPage(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Page updatePageProperties(@NotNull PagesSupport this_, @NotNull UpdatePagePropertiesRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.patchTextBody$default(this_.getHttpClient(), this_.getLogger(), this_.getBaseUrl() + "/pages/" + request.getPageId(), null, this_.getJsonSerializer().toJsonString(request), this_.buildRequestHeaders(MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json"))), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toPage(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull PagesSupport this_, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            return EndpointsSupport.DefaultImpls.buildRequestHeaders(this_, additionalOnes);
        }

        @NotNull
        public static String urlEncode(@NotNull PagesSupport this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return EndpointsSupport.DefaultImpls.urlEncode(this_, value);
        }
    }
}

