/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.endpoint;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import notion.api.v1.endpoint.EndpointsSupport;
import notion.api.v1.exception.NotionAPIError;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.json.NotionJsonSerializer;
import notion.api.v1.logging.NotionLogger;
import notion.api.v1.model.databases.Database;
import notion.api.v1.model.databases.Databases;
import notion.api.v1.model.databases.QueryResults;
import notion.api.v1.model.databases.query.filter.QueryFilter;
import notion.api.v1.model.databases.query.sort.QuerySort;
import notion.api.v1.request.databases.ListDatabasesRequest;
import notion.api.v1.request.databases.QueryDatabaseRequest;
import notion.api.v1.request.databases.RetrieveDatabaseRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016JK\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0010\b\u0002\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020%H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lnotion/api/v1/endpoint/DatabasesSupport;", "Lnotion/api/v1/endpoint/EndpointsSupport;", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "httpClient", "Lnotion/api/v1/http/NotionHttpClient;", "getHttpClient", "()Lnotion/api/v1/http/NotionHttpClient;", "jsonSerializer", "Lnotion/api/v1/json/NotionJsonSerializer;", "getJsonSerializer", "()Lnotion/api/v1/json/NotionJsonSerializer;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "getLogger", "()Lnotion/api/v1/logging/NotionLogger;", "listDatabases", "Lnotion/api/v1/model/databases/Databases;", "pageSize", "", "startCursor", "request", "Lnotion/api/v1/request/databases/ListDatabasesRequest;", "queryDatabase", "Lnotion/api/v1/model/databases/QueryResults;", "databaseId", "filter", "Lnotion/api/v1/model/databases/query/filter/QueryFilter;", "sorts", "", "Lnotion/api/v1/model/databases/query/sort/QuerySort;", "(Ljava/lang/String;Lnotion/api/v1/model/databases/query/filter/QueryFilter;Ljava/util/List;Ljava/lang/String;Ljava/lang/Integer;)Lnotion/api/v1/model/databases/QueryResults;", "Lnotion/api/v1/request/databases/QueryDatabaseRequest;", "retrieveDatabase", "Lnotion/api/v1/model/databases/Database;", "Lnotion/api/v1/request/databases/RetrieveDatabaseRequest;", "notion-sdk-jvm-core"})
public interface DatabasesSupport
extends EndpointsSupport {
    @NotNull
    public NotionHttpClient getHttpClient();

    @NotNull
    public NotionJsonSerializer getJsonSerializer();

    @NotNull
    public NotionLogger getLogger();

    @NotNull
    public String getBaseUrl();

    @NotNull
    public Databases listDatabases();

    @NotNull
    public Databases listDatabases(int var1, @NotNull String var2);

    @NotNull
    public Databases listDatabases(@NotNull ListDatabasesRequest var1);

    @NotNull
    public Database retrieveDatabase(@NotNull String var1);

    @NotNull
    public Database retrieveDatabase(@NotNull RetrieveDatabaseRequest var1);

    @NotNull
    public QueryResults queryDatabase(@NotNull String var1, @Nullable QueryFilter var2, @Nullable List<QuerySort> var3, @Nullable String var4, @Nullable Integer var5);

    @NotNull
    public QueryResults queryDatabase(@NotNull QueryDatabaseRequest var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Databases listDatabases(@NotNull DatabasesSupport this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.listDatabases(new ListDatabasesRequest(null, null, 3, null));
        }

        @NotNull
        public static Databases listDatabases(@NotNull DatabasesSupport this_, int pageSize, @NotNull String startCursor) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)startCursor, (String)"startCursor");
            return this_.listDatabases(new ListDatabasesRequest(startCursor, pageSize));
        }

        @NotNull
        public static Databases listDatabases(@NotNull DatabasesSupport this_, @NotNull ListDatabasesRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = this_.getHttpClient().get(this_.getLogger(), Intrinsics.stringPlus((String)this_.getBaseUrl(), (Object)"/databases"), request.buildPaginationParams(), this_.buildRequestHeaders(MapsKt.emptyMap()));
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toDatabases(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Database retrieveDatabase(@NotNull DatabasesSupport this_, @NotNull String databaseId) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
            return this_.retrieveDatabase(new RetrieveDatabaseRequest(databaseId));
        }

        @NotNull
        public static Database retrieveDatabase(@NotNull DatabasesSupport this_, @NotNull RetrieveDatabaseRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.get$default(this_.getHttpClient(), this_.getLogger(), this_.getBaseUrl() + "/databases/" + this_.urlEncode(request.getDatabaseId()), null, this_.buildRequestHeaders(MapsKt.emptyMap()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toDatabase(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static QueryResults queryDatabase(@NotNull DatabasesSupport this_, @NotNull String databaseId, @Nullable QueryFilter filter, @Nullable List<QuerySort> sorts, @Nullable String startCursor, @Nullable Integer pageSize) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
            return this_.queryDatabase(new QueryDatabaseRequest(databaseId, filter, sorts, startCursor, pageSize));
        }

        public static /* synthetic */ QueryResults queryDatabase$default(DatabasesSupport databasesSupport, String string, QueryFilter queryFilter, List list, String string2, Integer n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queryDatabase");
            }
            if ((n2 & 2) != 0) {
                queryFilter = null;
            }
            if ((n2 & 4) != 0) {
                list = null;
            }
            if ((n2 & 8) != 0) {
                string2 = null;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            return databasesSupport.queryDatabase(string, queryFilter, list, string2, n);
        }

        @NotNull
        public static QueryResults queryDatabase(@NotNull DatabasesSupport this_, @NotNull QueryDatabaseRequest request) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            NotionHttpResponse httpResponse = NotionHttpClient.DefaultImpls.postTextBody$default(this_.getHttpClient(), this_.getLogger(), this_.getBaseUrl() + "/databases/" + this_.urlEncode(request.getDatabaseId()) + "/query", null, this_.getJsonSerializer().toJsonString(request), this_.buildRequestHeaders(MapsKt.emptyMap()), 4, null);
            if (httpResponse.getStatus() == 200) {
                return this_.getJsonSerializer().toQueryResults(httpResponse.getBody());
            }
            throw new NotionAPIError(this_.getJsonSerializer().toError(httpResponse.getBody()), httpResponse, null, null, 12, null);
        }

        @NotNull
        public static Map<String, String> buildRequestHeaders(@NotNull DatabasesSupport this_, @NotNull Map<String, String> additionalOnes) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(additionalOnes, (String)"additionalOnes");
            return EndpointsSupport.DefaultImpls.buildRequestHeaders(this_, additionalOnes);
        }

        @NotNull
        public static String urlEncode(@NotNull DatabasesSupport this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return EndpointsSupport.DefaultImpls.urlEncode(this_, value);
        }
    }
}

