/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.sound;

import be.seeseemelk.mockbukkit.sound.AudioExperience;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Sound;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

public interface SoundReceiver {
    @NotNull
    public List<AudioExperience> getHeardSounds();

    default public void addHeardSound(@NotNull AudioExperience audioExperience) {
        Preconditions.checkNotNull((Object)audioExperience, (Object)"An audio experience must not be null.");
        this.getHeardSounds().add(audioExperience);
    }

    default public void clearSounds() {
        this.getHeardSounds().clear();
    }

    default public void assertSoundHeard(@NotNull Sound sound) {
        this.assertSoundHeard("Sound Heard Assertion failed", sound);
    }

    default public void assertSoundHeard(@NotNull String sound) {
        this.assertSoundHeard("Sound Heard Assertion failed", sound);
    }

    default public void assertSoundHeard(@NotNull Sound sound, @NotNull Predicate<AudioExperience> predicate) {
        this.assertSoundHeard("Sound Heard Assertion failed", sound, predicate);
    }

    default public void assertSoundHeard(@NotNull String sound, @NotNull Predicate<AudioExperience> predicate) {
        this.assertSoundHeard("Sound Heard Assertion failed", sound, predicate);
    }

    default public void assertSoundHeard(@NotNull String message, @NotNull Sound sound) {
        this.assertSoundHeard(message, sound, (AudioExperience e) -> true);
    }

    default public void assertSoundHeard(@NotNull String message, @NotNull String sound) {
        this.assertSoundHeard(message, sound, (AudioExperience e) -> true);
    }

    default public void assertSoundHeard(@NotNull String message, @NotNull Sound sound, @NotNull Predicate<AudioExperience> predicate) {
        this.assertSoundHeard(message, sound.getKey().getKey(), predicate);
    }

    default public void assertSoundHeard(@NotNull String message, @NotNull String sound, @NotNull Predicate<AudioExperience> predicate) {
        for (AudioExperience audio : this.getHeardSounds()) {
            if (!audio.getSound().equals(sound) || !predicate.test(audio)) continue;
            return;
        }
        Assertions.fail((String)message);
    }
}

