/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scheduler;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scheduler.AsyncTaskException;
import be.seeseemelk.mockbukkit.scheduler.RepeatingTask;
import be.seeseemelk.mockbukkit.scheduler.ScheduledTask;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scheduler.BukkitWorker;
import org.jetbrains.annotations.NotNull;

public class BukkitSchedulerMock
implements BukkitScheduler {
    private static final String LOGGER_NAME = "BukkitSchedulerMock";
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final ExecutorService asyncEventExecutor = Executors.newCachedThreadPool();
    private final List<Future<?>> queuedAsyncEvents = new ArrayList();
    private final TaskList scheduledTasks = new TaskList();
    private final AtomicReference<Exception> asyncException = new AtomicReference();
    private long currentTick = 0L;
    private int id = 0;
    private long executorTimeout = 60000L;

    private static Runnable wrapTask(ScheduledTask task) {
        return () -> {
            task.setRunning(true);
            task.run();
            task.setRunning(false);
        };
    }

    public void setShutdownTimeout(long timeout) {
        this.executorTimeout = timeout;
    }

    public void shutdown() {
        this.waitAsyncTasksFinished();
        this.shutdownPool(this.pool);
        if (this.asyncException.get() != null) {
            throw new AsyncTaskException(this.asyncException.get());
        }
        this.waitAsyncEventsFinished();
        this.shutdownPool(this.asyncEventExecutor);
    }

    private void shutdownPool(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(this.executorTimeout, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @NotNull
    public Future<?> executeAsyncEvent(Event event) {
        return this.executeAsyncEvent(event, null);
    }

    @NotNull
    public <T extends Event> Future<?> executeAsyncEvent(T event, Consumer<T> func) {
        Preconditions.checkNotNull(event, (Object)"Cannot call a null event!");
        Future<?> future = this.asyncEventExecutor.submit(() -> {
            MockBukkit.getMock().getPluginManager().callEvent(event);
            if (func != null) {
                func.accept(event);
            }
        });
        this.queuedAsyncEvents.add(future);
        return future;
    }

    public long getCurrentTick() {
        return this.currentTick;
    }

    public void performOneTick() {
        ++this.currentTick;
        List<ScheduledTask> oldTasks = this.scheduledTasks.getCurrentTaskList();
        for (ScheduledTask task : oldTasks) {
            if (task.getScheduledTick() != this.currentTick || task.isCancelled()) continue;
            if (task.isSync()) {
                BukkitSchedulerMock.wrapTask(task).run();
            } else {
                this.pool.submit(BukkitSchedulerMock.wrapTask(task));
            }
            if (!(task instanceof RepeatingTask) || task.isCancelled()) continue;
            ((RepeatingTask)task).updateScheduledTick();
            this.scheduledTasks.addTask(task);
        }
    }

    public void performTicks(long ticks) {
        for (long i = 0L; i < ticks; ++i) {
            this.performOneTick();
        }
    }

    public int getNumberOfQueuedAsyncTasks() {
        int queuedAsync = 0;
        for (ScheduledTask task : this.scheduledTasks.getCurrentTaskList()) {
            if (task.isSync() || task.isCancelled() || task.isRunning()) continue;
            ++queuedAsync;
        }
        return queuedAsync;
    }

    public void waitAsyncTasksFinished() {
        this.scheduledTasks.tasks.entrySet().stream().filter(entry -> entry.getValue() instanceof RepeatingTask).forEach(entry -> this.scheduledTasks.cancelTask((Integer)entry.getKey()));
        while (this.scheduledTasks.getScheduledTaskCount() > 0) {
            this.performOneTick();
        }
        long systemTime = System.currentTimeMillis();
        while (this.pool.getActiveCount() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            if (System.currentTimeMillis() <= systemTime + this.executorTimeout) continue;
            for (ScheduledTask task : this.scheduledTasks.getCurrentTaskList()) {
                if (!task.isRunning()) continue;
                task.cancel();
                this.cancelTask(task.getTaskId());
                throw new RuntimeException("Forced Cancellation of task owned by " + task.getOwner().getName());
            }
            this.pool.shutdownNow();
        }
    }

    public void waitAsyncEventsFinished() {
        for (Future<?> futureEvent : List.copyOf(this.queuedAsyncEvents)) {
            if (futureEvent.isDone()) {
                this.queuedAsyncEvents.remove(futureEvent);
                continue;
            }
            try {
                this.queuedAsyncEvents.remove(futureEvent);
                futureEvent.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    public BukkitTask runTask(@NotNull Plugin plugin, @NotNull Runnable task) {
        return this.runTaskLater(plugin, task, 1L);
    }

    @Deprecated
    @NotNull
    public BukkitTask runTask(@NotNull Plugin plugin, @NotNull BukkitRunnable task) {
        return this.runTask(plugin, (Runnable)task);
    }

    @NotNull
    public BukkitTask runTaskLater(@NotNull Plugin plugin, @NotNull Runnable task, long delay) {
        delay = Math.max(delay, 1L);
        ScheduledTask scheduledTask = new ScheduledTask(this.id++, plugin, true, this.currentTick + delay, task);
        this.scheduledTasks.addTask(scheduledTask);
        return scheduledTask;
    }

    @NotNull
    public BukkitTask runTaskTimer(@NotNull Plugin plugin, @NotNull Runnable task, long delay, long period) {
        delay = Math.max(delay, 1L);
        RepeatingTask repeatingTask = new RepeatingTask(this.id++, plugin, true, this.currentTick + delay, period, task);
        this.scheduledTasks.addTask(repeatingTask);
        return repeatingTask;
    }

    @Deprecated
    @NotNull
    public BukkitTask runTaskTimer(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay, long period) {
        return this.runTaskTimer(plugin, (Runnable)task, delay, period);
    }

    public int scheduleSyncDelayedTask(@NotNull Plugin plugin, @NotNull Runnable task, long delay) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskLater instead of scheduleSyncDelayTask");
        return this.runTaskLater(plugin, task, delay).getTaskId();
    }

    @Deprecated
    public int scheduleSyncDelayedTask(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskLater instead of scheduleSyncDelayTask");
        return this.runTaskLater(plugin, (Runnable)task, delay).getTaskId();
    }

    public int scheduleSyncDelayedTask(@NotNull Plugin plugin, @NotNull Runnable task) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTask instead of scheduleSyncDelayTask");
        return this.runTask(plugin, task).getTaskId();
    }

    @Deprecated
    public int scheduleSyncDelayedTask(@NotNull Plugin plugin, @NotNull BukkitRunnable task) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTask instead of scheduleSyncDelayTask");
        return this.runTask(plugin, (Runnable)task).getTaskId();
    }

    public int scheduleSyncRepeatingTask(@NotNull Plugin plugin, @NotNull Runnable task, long delay, long period) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskTimer instead of scheduleSyncRepeatingTask");
        return this.runTaskTimer(plugin, task, delay, period).getTaskId();
    }

    @Deprecated
    public int scheduleSyncRepeatingTask(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay, long period) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskTimer instead of scheduleSyncRepeatingTask");
        return this.runTaskTimer(plugin, (Runnable)task, delay, period).getTaskId();
    }

    @Deprecated
    public int scheduleAsyncDelayedTask(@NotNull Plugin plugin, @NotNull Runnable task, long delay) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskLaterAsynchronously instead of scheduleAsyncDelayedTask");
        return this.runTaskLaterAsynchronously(plugin, task, delay).getTaskId();
    }

    @Deprecated
    public int scheduleAsyncDelayedTask(@NotNull Plugin plugin, @NotNull Runnable task) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskAsynchronously instead of scheduleAsyncDelayedTask");
        return this.runTaskAsynchronously(plugin, task).getTaskId();
    }

    @Deprecated
    public int scheduleAsyncRepeatingTask(@NotNull Plugin plugin, @NotNull Runnable task, long delay, long period) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskTimerAsynchronously instead of scheduleAsyncRepeatingTask");
        return this.runTaskTimerAsynchronously(plugin, task, delay, period).getTaskId();
    }

    @NotNull
    public <T> Future<T> callSyncMethod(@NotNull Plugin plugin, @NotNull Callable<T> task) {
        throw new UnimplementedOperationException();
    }

    public void cancelTask(int taskId) {
        this.scheduledTasks.cancelTask(taskId);
    }

    public void cancelTasks(@NotNull Plugin plugin) {
        for (ScheduledTask task : this.scheduledTasks.getCurrentTaskList()) {
            if (!Objects.equals(task.getOwner(), plugin)) continue;
            task.cancel();
        }
    }

    public boolean isCurrentlyRunning(int taskId) {
        throw new UnimplementedOperationException();
    }

    public boolean isQueued(int taskId) {
        for (ScheduledTask task : this.scheduledTasks.getCurrentTaskList()) {
            if (task.getTaskId() != taskId) continue;
            return !task.isCancelled();
        }
        return false;
    }

    @NotNull
    public List<BukkitWorker> getActiveWorkers() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<BukkitTask> getPendingTasks() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BukkitTask runTaskAsynchronously(@NotNull Plugin plugin, @NotNull Runnable task) {
        ScheduledTask scheduledTask = new ScheduledTask(this.id++, plugin, false, this.currentTick, new AsyncRunnable(task));
        this.pool.execute(BukkitSchedulerMock.wrapTask(scheduledTask));
        return scheduledTask;
    }

    @NotNull
    public BukkitTask runTaskAsynchronously(@NotNull Plugin plugin, @NotNull BukkitRunnable task) {
        return this.runTaskAsynchronously(plugin, (Runnable)task);
    }

    @NotNull
    public BukkitTask runTaskLater(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay) {
        return this.runTaskLater(plugin, (Runnable)task, delay);
    }

    @NotNull
    public BukkitTask runTaskLaterAsynchronously(@NotNull Plugin plugin, @NotNull Runnable task, long delay) {
        ScheduledTask scheduledTask = new ScheduledTask(this.id++, plugin, false, this.currentTick + delay, new AsyncRunnable(task));
        this.scheduledTasks.addTask(scheduledTask);
        return scheduledTask;
    }

    @NotNull
    public BukkitTask runTaskLaterAsynchronously(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay) {
        return this.runTaskLaterAsynchronously(plugin, (Runnable)task, delay);
    }

    @NotNull
    public BukkitTask runTaskTimerAsynchronously(@NotNull Plugin plugin, @NotNull Runnable task, long delay, long period) {
        RepeatingTask scheduledTask = new RepeatingTask(this.id++, plugin, false, this.currentTick + delay, period, new AsyncRunnable(task));
        this.scheduledTasks.addTask(scheduledTask);
        return scheduledTask;
    }

    @NotNull
    public BukkitTask runTaskTimerAsynchronously(@NotNull Plugin plugin, @NotNull BukkitRunnable task, long delay, long period) {
        return this.runTaskTimerAsynchronously(plugin, (Runnable)task, delay, period);
    }

    public void runTask(@NotNull Plugin plugin, @NotNull Consumer<BukkitTask> task) {
        throw new UnimplementedOperationException();
    }

    public void runTaskAsynchronously(@NotNull Plugin plugin, @NotNull Consumer<BukkitTask> task) {
        throw new UnimplementedOperationException();
    }

    public void runTaskLater(@NotNull Plugin plugin, @NotNull Consumer<BukkitTask> task, long delay) {
        throw new UnimplementedOperationException();
    }

    public void runTaskLaterAsynchronously(@NotNull Plugin plugin, @NotNull Consumer<BukkitTask> task, long delay) {
        throw new UnimplementedOperationException();
    }

    public void runTaskTimer(@NotNull Plugin plugin, @NotNull Consumer<BukkitTask> task, long delay, long period) {
        throw new UnimplementedOperationException();
    }

    public void runTaskTimerAsynchronously(@NotNull Plugin plugin, @NotNull Consumer<BukkitTask> task, long delay, long period) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Executor getMainThreadExecutor(@NotNull Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    protected int getActiveRunningCount() {
        return this.pool.getActiveCount();
    }

    private static class TaskList {
        private final Map<Integer, ScheduledTask> tasks = new ConcurrentHashMap<Integer, ScheduledTask>();

        private TaskList() {
        }

        private boolean addTask(ScheduledTask task) {
            if (task == null) {
                return false;
            }
            this.tasks.put(task.getTaskId(), task);
            return true;
        }

        protected final List<ScheduledTask> getCurrentTaskList() {
            ArrayList<ScheduledTask> out = new ArrayList<ScheduledTask>();
            if (this.tasks.size() != 0) {
                out.addAll(this.tasks.values());
            }
            return out;
        }

        protected int getScheduledTaskCount() {
            int scheduled = 0;
            if (this.tasks.size() == 0) {
                return 0;
            }
            for (ScheduledTask task : this.tasks.values()) {
                if (task.isCancelled() || task.isRunning()) continue;
                ++scheduled;
            }
            return scheduled;
        }

        protected boolean cancelTask(int taskID) {
            if (this.tasks.containsKey(taskID)) {
                ScheduledTask task = this.tasks.get(taskID);
                task.cancel();
                this.tasks.put(taskID, task);
                return true;
            }
            return false;
        }
    }

    class AsyncRunnable
    implements Runnable {
        private final Runnable task;

        private AsyncRunnable(Runnable runnable) {
            this.task = runnable;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Exception t) {
                BukkitSchedulerMock.this.asyncException.set(t);
            }
        }
    }
}

