/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.profile;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerProfileMock
implements PlayerProfile {
    private String name;
    private UUID uuid;
    private final Set<ProfileProperty> properties;

    public PlayerProfileMock(PlayerMock player) {
        this(player.getName(), player.getUniqueId());
    }

    public PlayerProfileMock(String name, UUID uuid) {
        this.name = name;
        this.uuid = uuid;
        this.properties = new HashSet<ProfileProperty>();
    }

    public PlayerProfileMock(PlayerProfileMock profile) {
        this.name = profile.getName();
        this.uuid = profile.getUniqueId();
        this.properties = new HashSet<ProfileProperty>(profile.getProperties());
    }

    @Deprecated
    @Nullable
    public UUID getUniqueId() {
        return this.getId();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public String setName(@Nullable String name) {
        String oldName = this.name;
        this.name = name;
        return oldName;
    }

    @Nullable
    public UUID getId() {
        return this.uuid;
    }

    @Nullable
    public UUID setId(@Nullable UUID uuid) {
        UUID oldUuid = this.uuid;
        this.uuid = uuid;
        return oldUuid;
    }

    @NotNull
    public PlayerTextures getTextures() {
        throw new UnimplementedOperationException();
    }

    public void setTextures(@Nullable PlayerTextures textures) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<ProfileProperty> getProperties() {
        return this.properties;
    }

    public boolean hasProperty(@Nullable String property) {
        return this.properties.stream().anyMatch(p -> p.getName().equals(property));
    }

    public void setProperty(@NotNull ProfileProperty property) {
        this.properties.add(property);
    }

    public void setProperties(@NotNull Collection<ProfileProperty> properties) {
        this.properties.addAll(properties);
    }

    public boolean removeProperty(@Nullable String property) {
        return this.properties.removeIf(p -> p.getName().equals(property));
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public boolean isComplete() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public CompletableFuture<org.bukkit.profile.PlayerProfile> update() {
        throw new UnimplementedOperationException();
    }

    public boolean completeFromCache() {
        throw new UnimplementedOperationException();
    }

    public boolean completeFromCache(boolean onlineMode) {
        throw new UnimplementedOperationException();
    }

    public boolean completeFromCache(boolean lookupUUID, boolean onlineMode) {
        throw new UnimplementedOperationException();
    }

    public boolean complete(boolean textures) {
        throw new UnimplementedOperationException();
    }

    public boolean complete(boolean textures, boolean onlineMode) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Map<String, Object> serialize() {
        throw new UnimplementedOperationException();
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlayerProfileMock)) {
            return false;
        }
        PlayerProfileMock otherProfile = (PlayerProfileMock)obj;
        return Objects.equals(this.name, otherProfile.name) && this.uuid.equals(otherProfile.uuid) && this.properties.equals(otherProfile.properties);
    }

    public String toString() {
        return "CraftPlayerProfile [uniqueId=" + this.getId() + ", name=" + this.getName() + "]";
    }

    public @NotNull org.bukkit.profile.PlayerProfile clone() {
        return new PlayerProfileMock(this);
    }
}

