/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.potion;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class MockPotionEffectType
extends PotionEffectType {
    private final int id;
    private final String name;
    private final boolean instant;
    private final Color color;
    private final Map<Attribute, AttributeModifier> attributeModifiers;

    public MockPotionEffectType(NamespacedKey key, int id, String name, boolean instant, Color color) {
        super(id, key);
        this.id = id;
        this.name = name;
        this.instant = instant;
        this.color = color;
        this.attributeModifiers = new EnumMap<Attribute, AttributeModifier>(Attribute.class);
    }

    @Deprecated
    public double getDurationModifier() {
        return 1.0;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isInstant() {
        return this.instant;
    }

    @NotNull
    public Color getColor() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PotionEffectType) {
            return this.id == ((PotionEffectType)obj).getId();
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        this.attributeModifiers.put(attribute, modifier);
    }

    @NotNull
    public Map<Attribute, AttributeModifier> getEffectAttributes() {
        return ImmutableMap.copyOf(this.attributeModifiers);
    }

    public double getAttributeModifierAmount(@NotNull Attribute attribute, int effectAmplifier) {
        Preconditions.checkArgument((effectAmplifier >= 0 ? 1 : 0) != 0, (Object)"effectAmplifier must be greater than or equal to 0");
        Preconditions.checkArgument((boolean)this.attributeModifiers.containsKey(attribute), (Object)(attribute + " is not present on " + this.getKey()));
        return this.getAttributeModifierValue(effectAmplifier, this.attributeModifiers.get(attribute));
    }

    private double getAttributeModifierValue(int amplifier, AttributeModifier modifier) {
        return modifier.getAmount() * (double)(amplifier + 1);
    }

    @NotNull
    public PotionEffectType.Category getEffectCategory() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String translationKey() {
        throw new UnimplementedOperationException();
    }
}

