/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import org.apache.commons.lang3.Validate;
import org.bukkit.DyeColor;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.jetbrains.annotations.NotNull;

public class TropicalFishBucketMetaMock
extends ItemMetaMock
implements TropicalFishBucketMeta {
    private DyeColor patternColor;
    private DyeColor bodyColor;
    private TropicalFish.Pattern pattern;

    public TropicalFishBucketMetaMock() {
    }

    public TropicalFishBucketMetaMock(TropicalFishBucketMeta meta) {
        super((ItemMeta)meta);
        this.patternColor = meta.getPatternColor();
        this.bodyColor = meta.getBodyColor();
        this.pattern = meta.getPattern();
    }

    protected void checkVars() {
        if (this.patternColor == null) {
            this.patternColor = DyeColor.WHITE;
        }
        if (this.bodyColor == null) {
            this.bodyColor = DyeColor.WHITE;
        }
        if (this.pattern == null) {
            this.pattern = TropicalFish.Pattern.KOB;
        }
    }

    @NotNull
    public DyeColor getPatternColor() {
        Validate.notNull((Object)this.patternColor, (String)"Pattern color is not set", (Object[])new Object[0]);
        return this.patternColor;
    }

    public void setPatternColor(@NotNull DyeColor color) {
        this.checkVars();
        this.patternColor = color;
    }

    @NotNull
    public DyeColor getBodyColor() {
        Validate.notNull((Object)this.bodyColor, (String)"Body color is not set", (Object[])new Object[0]);
        return this.bodyColor;
    }

    public void setBodyColor(@NotNull DyeColor color) {
        this.checkVars();
        this.bodyColor = color;
    }

    @NotNull
    public TropicalFish.Pattern getPattern() {
        Validate.notNull((Object)this.pattern, (String)"Pattern is not set", (Object[])new Object[0]);
        return this.pattern;
    }

    public void setPattern(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TropicalFish.Pattern pattern) {
        this.checkVars();
        this.pattern = pattern;
    }

    public boolean hasVariant() {
        return this.patternColor != null && this.bodyColor != null && this.pattern != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bodyColor == null ? 0 : this.bodyColor.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (this.patternColor == null ? 0 : this.patternColor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TropicalFishBucketMeta)) {
            return false;
        }
        TropicalFishBucketMeta meta = (TropicalFishBucketMeta)obj;
        return super.equals(obj) && this.patternColor == meta.getPatternColor() && this.bodyColor == meta.getBodyColor() && this.pattern == meta.getPattern();
    }

    @Override
    @NotNull
    public TropicalFishBucketMetaMock clone() {
        TropicalFishBucketMetaMock clone = (TropicalFishBucketMetaMock)super.clone();
        clone.patternColor = this.patternColor;
        clone.bodyColor = this.bodyColor;
        clone.pattern = this.pattern;
        return clone;
    }
}

