/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class SuspiciousStewMetaMock
extends ItemMetaMock
implements SuspiciousStewMeta {
    private List<PotionEffect> effects = new ArrayList<PotionEffect>();

    public SuspiciousStewMetaMock() {
    }

    public SuspiciousStewMetaMock(SuspiciousStewMeta meta) {
        super((ItemMeta)meta);
        this.effects = new ArrayList<PotionEffect>(meta.getCustomEffects());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.effects.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SuspiciousStewMetaMock)) {
            return false;
        }
        SuspiciousStewMetaMock meta = (SuspiciousStewMetaMock)obj;
        return this.effects.equals(meta.effects);
    }

    @Override
    @NotNull
    public SuspiciousStewMetaMock clone() {
        SuspiciousStewMetaMock mock = (SuspiciousStewMetaMock)super.clone();
        mock.effects = new ArrayList<PotionEffect>(this.effects);
        return mock;
    }

    public boolean addCustomEffect(@NotNull PotionEffect effect, boolean overwrite) {
        int index = this.indexOf(effect.getType());
        if (index == -1) {
            this.effects.add(effect);
            return true;
        }
        if (!overwrite) {
            return false;
        }
        PotionEffect prev = this.effects.get(index);
        if (prev.getDuration() == effect.getDuration()) {
            return false;
        }
        this.effects.set(index, effect);
        return true;
    }

    public boolean clearCustomEffects() {
        boolean empty = this.effects.isEmpty();
        this.effects.clear();
        return !empty;
    }

    @NotNull
    public List<PotionEffect> getCustomEffects() {
        return ImmutableList.copyOf(this.effects);
    }

    public boolean hasCustomEffect(@NotNull PotionEffectType type) {
        return this.indexOf(type) != -1;
    }

    public boolean hasCustomEffects() {
        return !this.effects.isEmpty();
    }

    public boolean removeCustomEffect(@NotNull PotionEffectType type) {
        Iterator<PotionEffect> iterator = this.effects.iterator();
        boolean changed = false;
        while (iterator.hasNext()) {
            PotionEffect effect = iterator.next();
            if (!type.equals((Object)effect.getType())) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    private int indexOf(PotionEffectType type) {
        for (int i = 0; i < this.effects.size(); ++i) {
            if (!this.effects.get(i).getType().equals((Object)type)) continue;
            return i;
        }
        return -1;
    }
}

