/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class FireworkMetaMock
extends ItemMetaMock
implements FireworkMeta {
    private List<FireworkEffect> effects = new ArrayList<FireworkEffect>();
    private int power = 0;

    public FireworkMetaMock() {
    }

    public FireworkMetaMock(FireworkMeta meta) {
        super((ItemMeta)meta);
        this.effects.addAll(meta.getEffects());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.effects.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FireworkMetaMock)) {
            return false;
        }
        FireworkMetaMock other = (FireworkMetaMock)obj;
        return this.effects.equals(other.effects);
    }

    @Override
    public FireworkMetaMock clone() {
        FireworkMetaMock mock = (FireworkMetaMock)super.clone();
        mock.effects = new ArrayList<FireworkEffect>(this.effects);
        return mock;
    }

    public void addEffect(@NotNull FireworkEffect effect) {
        Preconditions.checkNotNull((Object)effect, (Object)"effect must never be null");
        this.effects.add(effect);
    }

    public void addEffects(FireworkEffect ... effects) {
        Preconditions.checkNotNull((Object)effects, (Object)"effects must never be null");
        for (FireworkEffect effect : effects) {
            this.addEffect(effect);
        }
    }

    public void addEffects(@NotNull Iterable<FireworkEffect> effects) {
        Preconditions.checkNotNull(effects, (Object)"effects must never be null");
        for (FireworkEffect effect : effects) {
            this.addEffect(effect);
        }
    }

    @NotNull
    public List<FireworkEffect> getEffects() {
        return ImmutableList.copyOf(this.effects);
    }

    public int getEffectsSize() {
        return this.effects.size();
    }

    public void removeEffect(int index) {
        this.effects.remove(index);
    }

    public void clearEffects() {
        this.effects.clear();
    }

    public boolean hasEffects() {
        return !this.effects.isEmpty();
    }

    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        if (power < 0 || power > 128) {
            throw new IllegalArgumentException("Power must be between 0 and 128");
        }
        this.power = power;
    }
}

