/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.returnsreceiver.qual.This;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class BookMetaMock
extends ItemMetaMock
implements BookMeta {
    private String title;
    private List<String> pages = new ArrayList<String>();
    private String author;

    public BookMetaMock() {
    }

    public BookMetaMock(BookMeta meta) {
        super((ItemMeta)meta);
        this.title = meta.getTitle();
        this.author = meta.getAuthor();
        this.pages = new ArrayList<String>(meta.getPages());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.author, this.pages, this.title);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BookMetaMock)) {
            return false;
        }
        BookMetaMock other = (BookMetaMock)obj;
        return Objects.equals(this.author, other.author) && Objects.equals(this.pages, other.pages) && Objects.equals(this.title, other.title);
    }

    public boolean hasTitle() {
        return !Strings.isNullOrEmpty((String)this.title);
    }

    public boolean hasPages() {
        return !this.pages.isEmpty();
    }

    @Nullable
    public Component title() {
        throw new UnimplementedOperationException();
    }

    public @This @NotNull BookMeta title(@Nullable Component title) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Component author() {
        throw new UnimplementedOperationException();
    }

    public @This @NotNull BookMeta author(@Nullable Component author) {
        throw new UnimplementedOperationException();
    }

    public @Unmodifiable @NotNull List<Component> pages() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Book pages(@NotNull List<Component> pages) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Component page(int page) {
        throw new UnimplementedOperationException();
    }

    public void page(int page, @NotNull Component data) {
        throw new UnimplementedOperationException();
    }

    public void addPages(Component ... pages) {
        throw new UnimplementedOperationException();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BookMeta.BookMetaBuilder toBuilder() {
        throw new UnimplementedOperationException();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean setTitle(String title) {
        if (title == null) {
            this.title = null;
            return true;
        }
        if (title.length() > 65535) {
            return false;
        }
        this.title = title;
        return true;
    }

    public boolean hasAuthor() {
        return !Strings.isNullOrEmpty((String)this.author);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Deprecated
    public String getPage(int page) {
        Preconditions.checkArgument((boolean)this.isValidPage(page), (Object)"Invalid page number");
        return this.pages.get(page - 1);
    }

    private boolean isValidPage(int page) {
        return page > 0 && page <= this.pages.size();
    }

    @Deprecated
    public void setPage(int page, String text) {
        if (!this.isValidPage(page)) {
            throw new IllegalArgumentException("Invalid page number " + page + "/" + this.pages.size());
        }
        String newText = text != null ? (text.length() > Short.MAX_VALUE ? text.substring(0, Short.MAX_VALUE) : text) : "";
        this.pages.set(page - 1, newText);
    }

    @Deprecated
    public List<String> getPages() {
        return this.pages;
    }

    @Deprecated
    public void setPages(String ... pages) {
        this.pages.clear();
        this.addPage(pages);
    }

    @Deprecated
    public void setPages(List<String> pages) {
        this.pages.clear();
        for (String page : pages) {
            this.addPage(page);
        }
    }

    @Deprecated
    public void addPage(String ... pages) {
        for (String page1 : pages) {
            String page = page1;
            if (page == null) {
                page = "";
            } else if (page.length() > Short.MAX_VALUE) {
                page = page.substring(0, Short.MAX_VALUE);
            }
            this.pages.add(page);
        }
    }

    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public BookMetaMock clone() {
        BookMetaMock mock = (BookMetaMock)super.clone();
        mock.pages = new ArrayList<String>(this.pages);
        return mock;
    }

    public boolean hasGeneration() {
        throw new UnimplementedOperationException();
    }

    public BookMeta.Generation getGeneration() {
        throw new UnimplementedOperationException();
    }

    public void setGeneration(BookMeta.Generation generation) {
        throw new UnimplementedOperationException();
    }

    public BookMeta.Spigot spigot() {
        throw new UnimplementedOperationException();
    }
}

