/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BannerMetaMock
extends ItemMetaMock
implements BannerMeta {
    private DyeColor baseColor;
    private List<Pattern> patterns;

    public BannerMetaMock() {
        this.patterns = new ArrayList<Pattern>();
    }

    public BannerMetaMock(BannerMeta meta) {
        super((ItemMeta)meta);
        this.baseColor = meta.getBaseColor();
        this.patterns = new ArrayList<Pattern>(meta.getPatterns());
    }

    @Nullable
    public DyeColor getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(@Nullable DyeColor color) {
        this.baseColor = color;
    }

    @NotNull
    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    public void setPatterns(@NotNull List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    public void addPattern(@NotNull Pattern pattern) {
        this.patterns.add(pattern);
    }

    @NotNull
    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    @NotNull
    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    public void setPattern(int i, @NotNull Pattern pattern) {
        this.patterns.set(i, pattern);
    }

    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.baseColor == null ? 0 : this.baseColor.hashCode());
        result = 31 * result + this.patterns.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BannerMeta)) {
            return false;
        }
        BannerMeta meta = (BannerMeta)obj;
        return super.equals(obj) && this.baseColor == meta.getBaseColor() && this.patterns.equals(meta.getPatterns());
    }

    @Override
    @NotNull
    public BannerMetaMock clone() {
        BannerMetaMock clone = (BannerMetaMock)super.clone();
        clone.baseColor = this.baseColor;
        clone.patterns = new ArrayList<Pattern>(this.patterns);
        return clone;
    }
}

