/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.AsyncCatcher;
import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.HumanEntityMock;
import be.seeseemelk.mockbukkit.inventory.EnderChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryViewMock;
import be.seeseemelk.mockbukkit.inventory.SimpleInventoryViewMock;
import be.seeseemelk.mockbukkit.map.MapViewMock;
import be.seeseemelk.mockbukkit.sound.AudioExperience;
import be.seeseemelk.mockbukkit.sound.SoundReceiver;
import be.seeseemelk.mockbukkit.statistic.StatisticsMock;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.Title;
import com.destroystokyo.paper.block.TargetBlockInfo;
import com.destroystokyo.paper.entity.TargetEntityInfo;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Instrument;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.Tag;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public class PlayerMock
extends HumanEntityMock
implements Player,
SoundReceiver {
    private boolean online;
    private PlayerInventoryMock inventory = null;
    private EnderChestInventoryMock enderChest = null;
    private final ServerMock server;
    private GameMode gamemode;
    private GameMode previousGamemode = this.gamemode = GameMode.SURVIVAL;
    private Component displayName = null;
    private Component playerListName = null;
    private Component playerListHeader = null;
    private Component playerListFooter = null;
    private int expTotal = 0;
    private float exp = 0.0f;
    private int foodLevel = 20;
    private float saturation = 5.0f;
    private int expLevel = 0;
    private boolean sneaking = false;
    private boolean sprinting = false;
    private boolean allowFlight = false;
    private boolean flying = false;
    private boolean whitelisted = true;
    private InventoryView inventoryView;
    private Location compassTarget;
    private Location bedSpawnLocation;
    private ItemStack cursor = null;
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private InetSocketAddress address;
    private final PlayerSpigotMock playerSpigotMock = new PlayerSpigotMock();
    private final List<AudioExperience> heardSounds = new LinkedList<AudioExperience>();
    private final Map<UUID, Set<Plugin>> hiddenPlayers = new HashMap<UUID, Set<Plugin>>();
    private final Set<UUID> hiddenPlayersDeprecated = new HashSet<UUID>();
    private final Queue<String> title = new LinkedTransferQueue<String>();
    private final Queue<String> subitles = new LinkedTransferQueue<String>();
    private final StatisticsMock statistics = new StatisticsMock();
    private final Set<String> channels = new HashSet<String>();

    public PlayerMock(@NotNull ServerMock server, @NotNull String name) {
        this(server, name, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)));
        this.online = false;
        this.firstPlayed = 0L;
    }

    public PlayerMock(@NotNull ServerMock server, @NotNull String name, @NotNull UUID uuid) {
        super(server, uuid);
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.setName(name);
        this.setDisplayName(name);
        this.online = true;
        this.server = server;
        this.firstPlayed = System.currentTimeMillis();
        if (Bukkit.getWorlds().isEmpty()) {
            MockBukkit.getMock().addSimpleWorld("world");
        }
        this.setLocation(((World)Bukkit.getWorlds().get(0)).getSpawnLocation().clone());
        this.setCompassTarget(this.getLocation());
        this.closeInventory();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.address = new InetSocketAddress("192.0.2." + ((Random)random).nextInt(255), random.nextInt(32768, 65535));
    }

    public boolean disconnect() {
        if (!this.online) {
            return false;
        }
        this.online = false;
        this.lastPlayed = System.currentTimeMillis();
        Component message = MiniMessage.miniMessage().deserialize("<name> has left the Server!", (TagResolver)Placeholder.component((String)"name", (ComponentLike)this.displayName()));
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)this, message, PlayerQuitEvent.QuitReason.DISCONNECTED);
        Bukkit.getPluginManager().callEvent((Event)playerQuitEvent);
        this.server.getPlayerList().disconnectPlayer(this);
        return true;
    }

    public boolean reconnect() {
        if (this.firstPlayed == 0L) {
            throw new IllegalStateException("Player was never online");
        }
        if (this.online) {
            return false;
        }
        this.online = true;
        this.lastPlayed = System.currentTimeMillis();
        this.server.addPlayer(this);
        return true;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    public void assertGameMode(GameMode expectedGamemode) {
        Assertions.assertEquals((Object)expectedGamemode, (Object)this.gamemode);
    }

    protected BlockDamageEvent simulateBlockDamagePure(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        BlockDamageEvent event = new BlockDamageEvent((Player)this, block, this.getItemInHand(), false);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Nullable
    public BlockDamageEvent simulateBlockDamage(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        if (this.gamemode != GameMode.SURVIVAL) {
            return null;
        }
        BlockDamageEvent event = this.simulateBlockDamagePure(block);
        if (event.getInstaBreak()) {
            BlockBreakEvent breakEvent = new BlockBreakEvent(block, (Player)this);
            Bukkit.getPluginManager().callEvent((Event)breakEvent);
            if (!breakEvent.isCancelled()) {
                block.setType(Material.AIR);
            }
        }
        return event;
    }

    @Nullable
    public BlockBreakEvent simulateBlockBreak(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        if (this.gamemode == GameMode.SPECTATOR || this.gamemode == GameMode.ADVENTURE || this.gamemode == GameMode.SURVIVAL && this.simulateBlockDamagePure(block).isCancelled()) {
            return null;
        }
        BlockBreakEvent event = new BlockBreakEvent(block, (Player)this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            block.setType(Material.AIR);
        }
        return event;
    }

    @Nullable
    public BlockPlaceEvent simulateBlockPlace(@NotNull Material material, @NotNull Location location) {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        if (this.gamemode == GameMode.ADVENTURE || this.gamemode == GameMode.SPECTATOR) {
            return null;
        }
        Block block = location.getBlock();
        BlockState blockState = block.getState();
        block.setType(material);
        BlockPlaceEvent event = new BlockPlaceEvent(block, blockState, null, this.getItemInHand(), (Player)this, true, EquipmentSlot.HAND);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !event.canBuild()) {
            blockState.update(true, false);
        }
        return event;
    }

    public InventoryClickEvent simulateInventoryClick(int slot) {
        return this.simulateInventoryClick(this.getOpenInventory(), slot);
    }

    public InventoryClickEvent simulateInventoryClick(@NotNull InventoryView inventoryView, int slot) {
        return this.simulateInventoryClick(inventoryView, ClickType.LEFT, slot);
    }

    public InventoryClickEvent simulateInventoryClick(@NotNull InventoryView inventoryView, ClickType clickType, int slot) {
        Preconditions.checkNotNull((Object)inventoryView, (Object)"InventoryView cannot be null");
        InventoryClickEvent inventoryClickEvent = new InventoryClickEvent(inventoryView, InventoryType.SlotType.CONTAINER, slot, clickType, InventoryAction.UNKNOWN);
        Bukkit.getPluginManager().callEvent((Event)inventoryClickEvent);
        return inventoryClickEvent;
    }

    public void respawn() {
        Location respawnLocation = this.getBedSpawnLocation();
        boolean isBedSpawn = respawnLocation != null;
        boolean isAnchorSpawn = false;
        if (!isBedSpawn) {
            respawnLocation = this.getLocation().getWorld().getSpawnLocation();
        }
        PlayerRespawnEvent event = new PlayerRespawnEvent((Player)this, respawnLocation, isBedSpawn, isAnchorSpawn);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.setHealth(this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        this.setLocation(event.getRespawnLocation().clone());
        this.alive = true;
    }

    @NotNull
    public PlayerMoveEvent simulatePlayerMove(@NotNull Location moveLocation) {
        Preconditions.checkNotNull((Object)moveLocation, (Object)"Location cannot be null");
        PlayerMoveEvent event = new PlayerMoveEvent((Player)this, this.getLocation(), moveLocation);
        this.setLocation(event.getTo());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.setLocation(event.getFrom());
        }
        return event;
    }

    @NotNull
    public PlayerInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = (PlayerInventoryMock)Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.PLAYER);
        }
        return this.inventory;
    }

    @NotNull
    public GameMode getGameMode() {
        return this.gamemode;
    }

    public void setGameMode(@NotNull GameMode mode) {
        Preconditions.checkNotNull((Object)mode, (Object)"GameMode cannot be null");
        if (this.gamemode == mode) {
            return;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this, mode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        if (!event.callEvent()) {
            return;
        }
        this.previousGamemode = this.gamemode;
        this.gamemode = mode;
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public void setWhitelisted(boolean value) {
        this.whitelisted = value;
    }

    public Player getPlayer() {
        return this.isOnline() ? this : null;
    }

    public boolean isOnline() {
        return this.getServer().getPlayer(this.getUniqueId()) != null;
    }

    public boolean isBanned() {
        return MockBukkit.getMock().getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    @NotNull
    public InventoryView getOpenInventory() {
        return this.inventoryView;
    }

    public void openInventory(@NotNull InventoryView inventory) {
        Preconditions.checkNotNull((Object)inventory, (Object)"Inventory cannot be null");
        this.closeInventory();
        this.inventoryView = inventory;
    }

    public InventoryView openInventory(@NotNull Inventory inventory) {
        AsyncCatcher.catchOp("open inventory");
        Preconditions.checkNotNull((Object)inventory, (Object)"Inventory cannot be null");
        this.closeInventory();
        if (inventory instanceof InventoryMock) {
            InventoryMock inventoryMock = (InventoryMock)inventory;
            inventoryMock.addViewers(this);
        }
        this.inventoryView = new PlayerInventoryViewMock(this, inventory);
        return this.inventoryView;
    }

    public void closeInventory() {
        if (this.inventoryView instanceof PlayerInventoryViewMock) {
            InventoryCloseEvent event = new InventoryCloseEvent(this.inventoryView);
            Bukkit.getPluginManager().callEvent((Event)event);
            Inventory inventory = this.inventoryView.getTopInventory();
            if (inventory instanceof InventoryMock) {
                InventoryMock inventoryMock = (InventoryMock)inventory;
                inventoryMock.removeViewer(this);
            }
        }
        this.cursor = null;
        this.inventoryView = new SimpleInventoryViewMock(this, null, this.inventory, InventoryType.CRAFTING);
    }

    public void closeInventory(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull InventoryCloseEvent.Reason reason) {
        throw new UnimplementedOperationException();
    }

    public void assertInventoryView(String message, InventoryType type, Predicate<Inventory> predicate) {
        InventoryView view = this.getOpenInventory();
        if (view.getType() == type && predicate.test(view.getTopInventory())) {
            return;
        }
        Assertions.fail((String)message);
    }

    public void assertInventoryView(InventoryType type, Predicate<Inventory> predicate) {
        this.assertInventoryView("The InventoryView Assertion has failed", type, predicate);
    }

    public void assertInventoryView(InventoryType type) {
        this.assertInventoryView("The InventoryView Assertion has failed", type, inv -> true);
    }

    public void assertInventoryView(String message, InventoryType type) {
        this.assertInventoryView(message, type, inv -> true);
    }

    public void updateInventory() {
    }

    public boolean performCommand(@NotNull String command) {
        Preconditions.checkNotNull((Object)command, (Object)"Command cannot be null");
        return Bukkit.dispatchCommand((CommandSender)this, (String)command);
    }

    @NotNull
    public Inventory getEnderChest() {
        if (this.enderChest == null) {
            this.enderChest = new EnderChestInventoryMock((InventoryHolder)this);
        }
        return this.enderChest;
    }

    @NotNull
    public MainHand getMainHand() {
        throw new UnimplementedOperationException();
    }

    public boolean setWindowProperty(@NotNull InventoryView.Property prop, int value) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openMerchant(@NotNull Villager trader, boolean force) {
        Preconditions.checkNotNull((Object)trader, (Object)"Trader cannot be null");
        return this.openMerchant((Merchant)trader, force);
    }

    public InventoryView openMerchant(@NotNull Merchant merchant, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openAnvil(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openCartographyTable(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openGrindstone(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openLoom(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openSmithingTable(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openStonecutter(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack getItemInHand() {
        return this.getInventory().getItemInMainHand();
    }

    public void setItemInHand(@Nullable ItemStack item) {
        this.getInventory().setItemInMainHand(item);
    }

    @NotNull
    public ItemStack getItemOnCursor() {
        return this.cursor == null ? new ItemStack(Material.AIR, 0) : this.cursor.clone();
    }

    public void setItemOnCursor(@Nullable ItemStack item) {
        this.cursor = item == null ? null : item.clone();
    }

    public boolean hasCooldown(@NotNull Material material) {
        throw new UnimplementedOperationException();
    }

    public int getCooldown(@NotNull Material material) {
        throw new UnimplementedOperationException();
    }

    public void setCooldown(@NotNull Material material, int ticks) {
        throw new UnimplementedOperationException();
    }

    public boolean isDeeplySleeping() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSleeping() {
        throw new UnimplementedOperationException();
    }

    public int getSleepTicks() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location getPotentialBedLocation() {
        throw new UnimplementedOperationException();
    }

    public boolean isBlocking() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isHandRaised() {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public EquipmentSlot getHandRaised() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isJumping() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setJumping(boolean jumping) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playPickupItemAnimation(@NotNull Item item, int quantity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public float getHurtDirection() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setHurtDirection(float hurtDirection) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ItemStack getItemInUse() {
        throw new UnimplementedOperationException();
    }

    public int getExpToLevel() {
        if (this.expLevel >= 31) {
            return 9 * this.expLevel - 158;
        }
        if (this.expLevel >= 16) {
            return 5 * this.expLevel - 38;
        }
        return 2 * this.expLevel + 7;
    }

    @Nullable
    public Entity releaseLeftShoulderEntity() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Entity releaseRightShoulderEntity() {
        throw new UnimplementedOperationException();
    }

    public Entity getShoulderEntityLeft() {
        throw new UnimplementedOperationException();
    }

    public void setShoulderEntityLeft(Entity entity) {
        throw new UnimplementedOperationException();
    }

    public Entity getShoulderEntityRight() {
        throw new UnimplementedOperationException();
    }

    public void setShoulderEntityRight(Entity entity) {
        throw new UnimplementedOperationException();
    }

    public void openSign(@NotNull Sign sign) {
        throw new UnimplementedOperationException();
    }

    public void showDemoScreen() {
        throw new UnimplementedOperationException();
    }

    public boolean isAllowingServerListings() {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getEyeHeight() {
        return this.getEyeHeight(false);
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (this.isSneaking() && !ignorePose) {
            return 1.54;
        }
        return 1.62;
    }

    @Override
    @NotNull
    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    @Nullable
    public Block getTargetBlock(int maxDistance, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TargetBlockInfo.FluidMode fluidMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    @Nullable
    public BlockFace getTargetBlockFace(int maxDistance, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TargetBlockInfo.FluidMode fluidMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    @Nullable
    public TargetBlockInfo getTargetBlockInfo(int maxDistance, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TargetBlockInfo.FluidMode fluidMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    @Nullable
    public Entity getTargetEntity(int maxDistance, boolean ignoreBlocks) {
        throw new UnimplementedOperationException();
    }

    @Override
    @Nullable
    public TargetEntityInfo getTargetEntityInfo(int maxDistance, boolean ignoreBlocks) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMaximumNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getLastDamage() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setLastDamage(double damage) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Player getKiller() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setKiller(@Nullable Player killer) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasLineOfSight(@NotNull Entity other) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasLineOfSight(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        return false;
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
    }

    @Override
    public EntityEquipment getEquipment() {
        return (EntityEquipment)this.getInventory();
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getCanPickupItems() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isLeashed() {
        return false;
    }

    @Override
    @NotNull
    public Entity getLeashHolder() {
        throw new IllegalStateException("Players cannot be leashed");
    }

    @Override
    public boolean setLeashHolder(@Nullable Entity holder) {
        return false;
    }

    @Override
    public void setAI(boolean ai) {
    }

    @Override
    public boolean hasAI() {
        return false;
    }

    @Override
    public void setCollidable(boolean collidable) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isCollidable() {
        throw new UnimplementedOperationException();
    }

    public boolean isConversing() {
        throw new UnimplementedOperationException();
    }

    public void acceptConversationInput(@NotNull String input) {
        throw new UnimplementedOperationException();
    }

    public boolean beginConversation(@NotNull Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(@NotNull Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(@NotNull Conversation conversation, @NotNull ConversationAbandonedEvent details) {
        throw new UnimplementedOperationException();
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.firstPlayed > 0L;
    }

    public void setLastPlayed(long time) {
        if (time > 0L) {
            this.lastPlayed = time;
            if (this.firstPlayed == 0L) {
                this.firstPlayed = time;
            }
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public void sendPluginMessage(@NotNull Plugin source, @NotNull String channel, byte[] message) {
        Preconditions.checkNotNull((Object)source, (Object)"Source cannot be null");
        Preconditions.checkNotNull((Object)channel, (Object)"Channel cannot be null");
        StandardMessenger.validatePluginMessage((Messenger)this.getServer().getMessenger(), (Plugin)source, (String)channel, (byte[])message);
    }

    @NotNull
    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    @NotNull
    public Component displayName() {
        return this.displayName;
    }

    public void displayName(@Nullable Component displayName) {
        this.displayName = displayName;
    }

    @Deprecated
    @NotNull
    public String getDisplayName() {
        return LegacyComponentSerializer.legacySection().serialize(this.displayName);
    }

    @Deprecated
    public void setDisplayName(String name) {
        this.displayName = LegacyComponentSerializer.legacySection().deserialize(name);
    }

    public void playerListName(@Nullable Component name) {
        this.playerListName = name;
    }

    @NotNull
    public Component playerListName() {
        return this.playerListName == null ? this.name() : this.playerListName;
    }

    @Nullable
    public Component playerListHeader() {
        return this.playerListHeader;
    }

    @Nullable
    public Component playerListFooter() {
        return this.playerListFooter;
    }

    @Deprecated
    @NotNull
    public String getPlayerListName() {
        return this.playerListName == null ? this.getName() : LegacyComponentSerializer.legacySection().serialize(this.playerListName);
    }

    @Deprecated
    public void setPlayerListName(@Nullable String name) {
        this.playerListName = name == null ? null : LegacyComponentSerializer.legacySection().deserialize(name);
    }

    public void setCompassTarget(@NotNull Location loc) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        this.compassTarget = loc;
    }

    @NotNull
    public Location getCompassTarget() {
        return this.compassTarget;
    }

    public void setAddress(@Nullable InetSocketAddress address) {
        this.address = address;
    }

    @Nullable
    public InetSocketAddress getAddress() {
        return this.isOnline() ? this.address : null;
    }

    public int getProtocolVersion() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InetSocketAddress getVirtualHost() {
        throw new UnimplementedOperationException();
    }

    public void sendRawMessage(@Nullable String message) {
        throw new UnimplementedOperationException();
    }

    public void sendRawMessage(@Nullable UUID sender, @NotNull String message) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void kickPlayer(String message) {
        throw new UnimplementedOperationException();
    }

    public void kick() {
        throw new UnimplementedOperationException();
    }

    public void kick(@Nullable Component message) {
        throw new UnimplementedOperationException();
    }

    public void kick(@Nullable Component message, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerKickEvent.Cause cause) {
        throw new UnimplementedOperationException();
    }

    public void chat(@NotNull String msg) {
        Preconditions.checkNotNull((Object)msg, (Object)"Message cannot be null");
        HashSet players = new HashSet(Bukkit.getOnlinePlayers());
        AsyncPlayerChatEvent asyncEvent = new AsyncPlayerChatEvent(true, (Player)this, msg, players);
        AsyncChatEvent asyncChatEvent = new AsyncChatEvent(true, (Player)this, new HashSet(Bukkit.getOnlinePlayers()), ChatRenderer.defaultRenderer(), (Component)Component.text((String)msg), (Component)Component.text((String)msg));
        PlayerChatEvent syncEvent = new PlayerChatEvent((Player)this, msg);
        this.server.getScheduler().executeAsyncEvent((Event)asyncChatEvent);
        this.server.getScheduler().executeAsyncEvent((Event)asyncEvent);
        this.server.getPluginManager().callEvent((Event)syncEvent);
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @NotNull
    public PlayerToggleSneakEvent simulateSneak(boolean sneak) {
        PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this, sneak);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.sneaking = event.isSneaking();
        }
        return event;
    }

    public boolean isSprinting() {
        return this.sprinting;
    }

    public void setSprinting(boolean sprinting) {
        this.sprinting = sprinting;
    }

    @NotNull
    public PlayerToggleSprintEvent simulateSprint(boolean sprint) {
        PlayerToggleSprintEvent event = new PlayerToggleSprintEvent((Player)this, sprint);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.sprinting = event.isSprinting();
        }
        return event;
    }

    public void saveData() {
        throw new UnimplementedOperationException();
    }

    public void loadData() {
        throw new UnimplementedOperationException();
    }

    public boolean isSleepingIgnored() {
        throw new UnimplementedOperationException();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void playNote(@NotNull Location loc, byte instrument, byte note) {
        this.playNote(loc, Instrument.getByType((byte)instrument), note);
    }

    public void playNote(@NotNull Location loc, @NotNull Instrument instrument, @NotNull Note note) {
        this.playNote(loc, instrument, note.getId());
    }

    private void playNote(@NotNull Location loc, @NotNull Instrument instrument, byte note) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)instrument, (Object)"Instrument cannot be null");
        Sound sound = switch (instrument) {
            case Instrument.BANJO -> Sound.BLOCK_NOTE_BLOCK_BANJO;
            case Instrument.BASS_DRUM -> Sound.BLOCK_NOTE_BLOCK_BASEDRUM;
            case Instrument.BASS_GUITAR -> Sound.BLOCK_NOTE_BLOCK_BASS;
            case Instrument.BELL -> Sound.BLOCK_NOTE_BLOCK_BELL;
            case Instrument.BIT -> Sound.BLOCK_NOTE_BLOCK_BIT;
            case Instrument.CHIME -> Sound.BLOCK_NOTE_BLOCK_CHIME;
            case Instrument.COW_BELL -> Sound.BLOCK_NOTE_BLOCK_COW_BELL;
            case Instrument.DIDGERIDOO -> Sound.BLOCK_NOTE_BLOCK_DIDGERIDOO;
            case Instrument.FLUTE -> Sound.BLOCK_NOTE_BLOCK_FLUTE;
            case Instrument.GUITAR -> Sound.BLOCK_NOTE_BLOCK_GUITAR;
            case Instrument.IRON_XYLOPHONE -> Sound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE;
            case Instrument.PIANO -> Sound.BLOCK_NOTE_BLOCK_HARP;
            case Instrument.PLING -> Sound.BLOCK_NOTE_BLOCK_PLING;
            case Instrument.SNARE_DRUM -> Sound.BLOCK_NOTE_BLOCK_SNARE;
            case Instrument.STICKS -> Sound.BLOCK_NOTE_BLOCK_HAT;
            case Instrument.XYLOPHONE -> Sound.BLOCK_NOTE_BLOCK_XYLOPHONE;
            default -> throw new UnimplementedOperationException("Instrument '" + instrument + "' has no implementation!");
        };
        float pitch = (float)Math.pow(2.0, ((double)note - 12.0) / 12.0);
        this.playSound(loc, sound, SoundCategory.RECORDS, 3.0f, pitch);
    }

    public void playSound(@NotNull Location location, @NotNull String sound, float volume, float pitch) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        this.heardSounds.add(new AudioExperience(sound, SoundCategory.MASTER, location, volume, pitch));
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Entity entity, @NotNull Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Location location, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        Preconditions.checkNotNull((Object)category, (Object)"Category cannot be null");
        this.heardSounds.add(new AudioExperience(sound, category, location, volume, pitch));
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        Preconditions.checkNotNull((Object)category, (Object)"Category cannot be null");
        this.heardSounds.add(new AudioExperience(sound, category, location, volume, pitch));
    }

    public void playSound(@NotNull Entity entity, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        Preconditions.checkNotNull((Object)category, (Object)"Category cannot be null");
        this.heardSounds.add(new AudioExperience(sound, category, entity.getLocation(), volume, pitch));
    }

    @Override
    @NotNull
    public List<AudioExperience> getHeardSounds() {
        return this.heardSounds;
    }

    @Override
    public void addHeardSound(@NotNull AudioExperience audioExperience) {
        Preconditions.checkNotNull((Object)audioExperience, (Object)"AudioExperience cannot be null");
        SoundReceiver.super.addHeardSound(audioExperience);
    }

    public void stopSound(@NotNull Sound sound) {
        this.stopSound(sound, SoundCategory.MASTER);
    }

    public void stopSound(@NotNull String sound) {
        this.stopSound(sound, SoundCategory.MASTER);
    }

    public void stopSound(@NotNull Sound sound, @Nullable SoundCategory category) {
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
    }

    public void stopSound(@NotNull String sound, @Nullable SoundCategory category) {
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
    }

    public void stopAllSounds() {
    }

    @Deprecated
    public void playEffect(@NotNull Location loc, @NotNull Effect effect, int data) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)effect, (Object)"Effect cannot be null");
    }

    public <T> void playEffect(@NotNull Location loc, @NotNull Effect effect, T data) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)effect, (Object)"Effect cannot be null");
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (Object)"Wrong kind of data for this effect!");
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (Object)"Wrong kind of data for this effect!");
        }
    }

    public boolean breakBlock(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals(this.getWorld()), (Object)"Cannot break blocks across worlds");
        BlockBreakEvent event = new BlockBreakEvent(block, (Player)this);
        boolean swordNoBreak = this.getGameMode() == GameMode.CREATIVE && this.getEquipment().getItemInMainHand().getType().name().contains("SWORD");
        event.setCancelled(swordNoBreak);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            block.setType(Material.AIR);
        }
        return !event.isCancelled();
    }

    @Deprecated
    public void sendBlockChange(@NotNull Location loc, @NotNull Material material, byte data) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
    }

    public void sendBlockChange(@NotNull Location loc, @NotNull BlockData block) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
    }

    public void sendSignChange(@NotNull Location loc, @Nullable List<Component> lines, @NotNull DyeColor dyeColor, boolean hasGlowingText) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)dyeColor, (Object)"DyeColor cannot be null");
        if (lines == null) {
            lines = new ArrayList<Component>(4);
        }
        if (lines.size() < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
    }

    @Deprecated
    public void sendSignChange(@NotNull Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    public void sendSignChange(@NotNull Location loc, String[] lines, @NotNull DyeColor dyeColor) throws IllegalArgumentException {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    public void sendSignChange(@NotNull Location loc, @Nullable String[] lines, @NotNull DyeColor dyeColor, boolean hasGlowingText) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)dyeColor, (Object)"DyeColor cannot be null");
        if (lines == null) {
            lines = new String[4];
        }
        if (lines.length < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
    }

    public void sendMap(@NotNull MapView map) {
        Preconditions.checkNotNull((Object)map, (Object)"Map cannot be null");
        if (!(map instanceof MapViewMock)) {
            return;
        }
        MapViewMock mapView = (MapViewMock)map;
        mapView.render(this);
    }

    @Deprecated
    public void sendActionBar(@NotNull String message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
    }

    @Deprecated
    public void sendActionBar(char alternateChar, @NotNull String message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
    }

    @Deprecated
    public void sendActionBar(BaseComponent ... message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
    }

    @Deprecated
    public void setPlayerListHeaderFooter(@Nullable BaseComponent[] header, @Nullable BaseComponent[] footer) {
        this.playerListHeader = BungeeComponentSerializer.get().deserialize((BaseComponent[])Arrays.stream(header).filter(Objects::nonNull).toArray(BaseComponent[]::new));
        this.playerListFooter = BungeeComponentSerializer.get().deserialize((BaseComponent[])Arrays.stream(footer).filter(Objects::nonNull).toArray(BaseComponent[]::new));
    }

    @Deprecated
    public void setPlayerListHeaderFooter(@Nullable BaseComponent header, @Nullable BaseComponent footer) {
        this.playerListHeader = BungeeComponentSerializer.get().deserialize(new BaseComponent[]{header});
        this.playerListFooter = BungeeComponentSerializer.get().deserialize(new BaseComponent[]{footer});
    }

    @Deprecated
    public void setTitleTimes(int fadeInTicks, int stayTicks, int fadeOutTicks) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setSubtitle(BaseComponent[] subtitle) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setSubtitle(BaseComponent subtitle) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void showTitle(@Nullable BaseComponent[] title) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void showTitle(@Nullable BaseComponent title) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void showTitle(@Nullable BaseComponent[] title, @Nullable BaseComponent[] subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void showTitle(@Nullable BaseComponent title, @Nullable BaseComponent subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void sendTitle(@NotNull Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
    }

    @Deprecated
    public void updateTitle(@NotNull Title title) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void hideTitle() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public GameMode getPreviousGameMode() {
        return this.previousGamemode;
    }

    public void incrementStatistic(@NotNull Statistic statistic) {
        this.statistics.incrementStatistic(statistic, 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic) {
        this.statistics.decrementStatistic(statistic, 1);
    }

    public void incrementStatistic(@NotNull Statistic statistic, int amount) {
        this.statistics.incrementStatistic(statistic, amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, int amount) {
        this.statistics.decrementStatistic(statistic, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, int newValue) {
        this.statistics.setStatistic(statistic, newValue);
    }

    public int getStatistic(@NotNull Statistic statistic) {
        return this.statistics.getStatistic(statistic);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        this.statistics.incrementStatistic(statistic, material, 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        this.statistics.decrementStatistic(statistic, material, 1);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        return this.statistics.getStatistic(statistic, material);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        this.statistics.incrementStatistic(statistic, material, amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        this.statistics.decrementStatistic(statistic, material, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull Material material, int newValue) {
        this.statistics.setStatistic(statistic, material, newValue);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        this.statistics.incrementStatistic(statistic, entityType, 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        this.statistics.decrementStatistic(statistic, entityType, 1);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        return this.statistics.getStatistic(statistic, entityType);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int amount) {
        this.statistics.incrementStatistic(statistic, entityType, amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int amount) {
        this.statistics.decrementStatistic(statistic, entityType, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int newValue) {
        this.statistics.setStatistic(statistic, entityType, newValue);
    }

    public void setPlayerTime(long time, boolean relative) {
        throw new UnimplementedOperationException();
    }

    public long getPlayerTime() {
        throw new UnimplementedOperationException();
    }

    public long getPlayerTimeOffset() {
        throw new UnimplementedOperationException();
    }

    public boolean isPlayerTimeRelative() {
        throw new UnimplementedOperationException();
    }

    public void resetPlayerTime() {
        throw new UnimplementedOperationException();
    }

    public WeatherType getPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    public void setPlayerWeather(@NotNull WeatherType type) {
        throw new UnimplementedOperationException();
    }

    public void resetPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    public void giveExp(int amount) {
        this.exp += (float)amount / (float)this.getExpToLevel();
        this.setTotalExperience(this.expTotal + amount);
        while (this.exp < 0.0f) {
            float total = this.exp * (float)this.getExpToLevel();
            boolean shouldContinue = this.expLevel > 0;
            this.giveExpLevels(-1);
            if (!shouldContinue) continue;
            this.exp = 1.0f + total / (float)this.getExpToLevel();
        }
        while (this.exp >= 1.0f) {
            this.exp = (this.exp - 1.0f) * (float)this.getExpToLevel();
            this.giveExpLevels(1);
            this.exp /= (float)this.getExpToLevel();
        }
    }

    public void giveExp(int amount, boolean applyMending) {
        throw new UnimplementedOperationException();
    }

    public int applyMending(int amount) {
        throw new UnimplementedOperationException();
    }

    public void giveExpLevels(int amount) {
        int oldLevel = this.expLevel;
        this.expLevel += amount;
        if (this.expLevel < 0) {
            this.expLevel = 0;
            this.exp = 0.0f;
        }
        if (oldLevel != this.expLevel) {
            PlayerLevelChangeEvent event = new PlayerLevelChangeEvent((Player)this, oldLevel, this.expLevel);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }

    public float getExp() {
        return this.exp;
    }

    public void setExp(float exp) {
        if ((double)exp < 0.0 || (double)exp > 1.0) {
            throw new IllegalArgumentException("Experience progress must be between 0.0 and 1.0");
        }
        this.exp = exp;
    }

    public int getLevel() {
        return this.expLevel;
    }

    public void setLevel(int level) {
        this.expLevel = level;
    }

    public int getTotalExperience() {
        return this.expTotal;
    }

    public void setTotalExperience(int exp) {
        this.expTotal = Math.max(0, exp);
    }

    public float getExhaustion() {
        throw new UnimplementedOperationException();
    }

    public void setExhaustion(float value) {
        throw new UnimplementedOperationException();
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float value) {
        this.saturation = Math.min((float)this.getFoodLevel(), value);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public void setFoodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
    }

    @Nullable
    public Location getBedSpawnLocation() {
        return this.bedSpawnLocation;
    }

    public long getLastLogin() {
        throw new UnimplementedOperationException();
    }

    public long getLastSeen() {
        throw new UnimplementedOperationException();
    }

    public void setBedSpawnLocation(@Nullable Location loc) {
        this.setBedSpawnLocation(loc, false);
    }

    public void setBedSpawnLocation(@Nullable Location loc, boolean force) {
        if (force || loc == null || Tag.BEDS.isTagged((Keyed)loc.getBlock().getType())) {
            this.bedSpawnLocation = loc;
        }
    }

    public boolean getAllowFlight() {
        return this.allowFlight;
    }

    public void setAllowFlight(boolean flight) {
        if (this.isFlying() && !flight) {
            this.flying = false;
        }
        this.allowFlight = flight;
    }

    @Deprecated
    public void hidePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.hiddenPlayersDeprecated.add(player.getUniqueId());
    }

    public void hidePlayer(@NotNull Plugin plugin, @NotNull Player player) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.hiddenPlayers.putIfAbsent(player.getUniqueId(), new HashSet());
        Set<Plugin> blockingPlugins = this.hiddenPlayers.get(player.getUniqueId());
        blockingPlugins.add(plugin);
    }

    @Deprecated
    public void showPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.hiddenPlayersDeprecated.remove(player.getUniqueId());
    }

    public void showPlayer(@NotNull Plugin plugin, @NotNull Player player) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        if (this.hiddenPlayers.containsKey(player.getUniqueId())) {
            Set<Plugin> blockingPlugins = this.hiddenPlayers.get(player.getUniqueId());
            blockingPlugins.remove(plugin);
            if (blockingPlugins.isEmpty()) {
                this.hiddenPlayers.remove(player.getUniqueId());
            }
        }
    }

    public boolean canSee(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        return !this.hiddenPlayers.containsKey(player.getUniqueId()) && !this.hiddenPlayersDeprecated.contains(player.getUniqueId());
    }

    @ApiStatus.Experimental
    public void hideEntity(@NotNull Plugin plugin, @NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    @ApiStatus.Experimental
    public void showEntity(@NotNull Plugin plugin, @NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    public boolean canSee(@NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean value) {
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.flying = value;
    }

    @NotNull
    public PlayerToggleFlightEvent simulateToggleFlight(boolean fly) {
        PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this, fly);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.flying = event.isFlying();
        }
        return event;
    }

    public float getFlySpeed() {
        throw new UnimplementedOperationException();
    }

    public void setFlySpeed(float value) {
        throw new UnimplementedOperationException();
    }

    public float getWalkSpeed() {
        throw new UnimplementedOperationException();
    }

    public void setWalkSpeed(float value) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setTexturePack(@NotNull String url) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setResourcePack(@NotNull String url) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, byte[] hash) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setResourcePack(@NotNull String url, @Nullable byte[] hash, @Nullable String prompt) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, byte[] hash, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setResourcePack(@NotNull String url, @Nullable byte[] hash, @Nullable String prompt, boolean force) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, byte @Nullable [] hash, @Nullable Component prompt, boolean force) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Scoreboard getScoreboard() {
        throw new UnimplementedOperationException();
    }

    public void setScoreboard(@NotNull Scoreboard scoreboard) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public WorldBorder getWorldBorder() {
        throw new UnimplementedOperationException();
    }

    public void setWorldBorder(@Nullable WorldBorder border) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setHealth(double health) {
        if (health > 0.0) {
            this.health = Math.min(health, this.getMaxHealth());
            return;
        }
        this.health = 0.0;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(Arrays.asList(this.getInventory().getContents()));
        PlayerDeathEvent event = new PlayerDeathEvent((Player)this, drops, 0, this.getName() + " got killed");
        Bukkit.getPluginManager().callEvent((Event)event);
        this.closeInventory();
        if (!((Boolean)this.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY)).booleanValue()) {
            this.getInventory().clear();
        }
        this.setLevel(0);
        this.setExp(0.0f);
        this.setFoodLevel(0);
        this.alive = false;
    }

    public boolean isHealthScaled() {
        throw new UnimplementedOperationException();
    }

    public void setHealthScaled(boolean scale) {
        throw new UnimplementedOperationException();
    }

    public double getHealthScale() {
        throw new UnimplementedOperationException();
    }

    public void setHealthScale(double scale) {
        throw new UnimplementedOperationException();
    }

    public void sendHealthUpdate(double health, int foodLevel, float saturationLevel) {
    }

    public void sendHealthUpdate() {
    }

    public Entity getSpectatorTarget() {
        throw new UnimplementedOperationException();
    }

    public void setSpectatorTarget(Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void sendTitle(String title, String subtitle) {
        this.title.add(title);
        this.subitles.add(subtitle);
    }

    @Deprecated
    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.sendTitle(title, subtitle);
    }

    public String nextTitle() {
        return this.title.poll();
    }

    public String nextSubTitle() {
        return this.subitles.poll();
    }

    public void resetTitle() {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        Preconditions.checkNotNull((Object)particle, (Object)"Particle cannot be null");
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
    }

    @NotNull
    public AdvancementProgress getAdvancementProgress(@NotNull Advancement advancement) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getLocale() {
        throw new UnimplementedOperationException();
    }

    public boolean getAffectsSpawning() {
        throw new UnimplementedOperationException();
    }

    public void setAffectsSpawning(boolean affects) {
        throw new UnimplementedOperationException();
    }

    public int getViewDistance() {
        throw new UnimplementedOperationException();
    }

    public void setViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public int getSimulationDistance() {
        throw new UnimplementedOperationException();
    }

    public void setSimulationDistance(int simulationDistance) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getNoTickViewDistance() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setNoTickViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public int getSendViewDistance() {
        throw new UnimplementedOperationException();
    }

    public void setSendViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSwimming() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSwimming(boolean swimming) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isRiptiding() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isPersistent() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPersistent(boolean persistent) {
        throw new UnimplementedOperationException();
    }

    public String getPlayerListHeader() {
        return LegacyComponentSerializer.legacySection().serialize(this.playerListHeader);
    }

    public void setPlayerListHeader(@Nullable String header) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
    }

    public String getPlayerListFooter() {
        return LegacyComponentSerializer.legacySection().serialize(this.playerListFooter);
    }

    public void setPlayerListFooter(@Nullable String footer) {
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
    }

    public void setPlayerListHeaderFooter(@Nullable String header, @Nullable String footer) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
    }

    public void updateCommands() {
        throw new UnimplementedOperationException();
    }

    public boolean discoverRecipe(@NotNull NamespacedKey recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"Recipe cannot be null");
        return this.discoverRecipes(Collections.singletonList(recipe)) != 0;
    }

    public int discoverRecipes(@NotNull Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    public boolean undiscoverRecipe(@NotNull NamespacedKey recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"Recipe cannot be null");
        return this.undiscoverRecipes(Collections.singletonList(recipe)) != 0;
    }

    public int undiscoverRecipes(@NotNull Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance, @NotNull FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getBeeStingerCooldown() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setBeeStingerCooldown(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getBeeStingersInBody() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setBeeStingersInBody(int count) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public BlockFace getFacing() {
        throw new UnimplementedOperationException();
    }

    public int getClientViewDistance() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Locale locale() {
        throw new UnimplementedOperationException();
    }

    public boolean sleep(@NotNull Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public void wakeup(boolean setSpawnLocation) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Location getBedLocation() {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public Pose getPose() {
        throw new UnimplementedOperationException();
    }

    public void openBook(@NotNull ItemStack book) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required, @Nullable Component resourcePackPrompt) {
        throw new UnimplementedOperationException();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PlayerResourcePackStatusEvent.Status getResourcePackStatus() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @Nullable
    public String getResourcePackHash() {
        throw new UnimplementedOperationException();
    }

    public boolean hasResourcePack() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PlayerProfile getPlayerProfile() {
        throw new UnimplementedOperationException();
    }

    public void setPlayerProfile(@NotNull PlayerProfile profile) {
        throw new UnimplementedOperationException();
    }

    public float getCooldownPeriod() {
        throw new UnimplementedOperationException();
    }

    public float getCooledAttackStrength(float adjustTicks) {
        throw new UnimplementedOperationException();
    }

    public void resetCooldown() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <T> T getClientOption(@NotNull ClientOption<T> option) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Firework boostElytra(@NotNull ItemStack firework) {
        throw new UnimplementedOperationException();
    }

    public void sendOpLevel(byte level) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public String getClientBrandName() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void attack(@NotNull Entity target) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void swingMainHand() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void swingOffHand() {
        throw new UnimplementedOperationException();
    }

    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
    }

    public float getAttackCooldown() {
        throw new UnimplementedOperationException();
    }

    public boolean hasDiscoveredRecipe(@NotNull NamespacedKey recipe) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<NamespacedKey> getDiscoveredRecipes() {
        throw new UnimplementedOperationException();
    }

    public boolean dropItem(boolean dropAll) {
        throw new UnimplementedOperationException();
    }

    public void sendBlockDamage(@NotNull Location loc, float progress) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
    }

    public void sendMultiBlockChange(@NotNull Map<Location, BlockData> blockChanges) {
        Preconditions.checkNotNull(blockChanges, (Object)"BlockChanges cannot be null");
    }

    public void sendMultiBlockChange(@NotNull Map<Location, BlockData> blockChanges, boolean suppressLightUpdates) {
        Preconditions.checkNotNull(blockChanges, (Object)"BlockChanges cannot be null");
    }

    public int getSaturatedRegenRate() {
        throw new UnimplementedOperationException();
    }

    public void setSaturatedRegenRate(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getUnsaturatedRegenRate() {
        throw new UnimplementedOperationException();
    }

    public void setUnsaturatedRegenRate(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getStarvationRate() {
        throw new UnimplementedOperationException();
    }

    public void setStarvationRate(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getPing() {
        return 0;
    }

    @Override
    public boolean teleport(@NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)cause, (Object)"Cause cannot be null");
        PlayerTeleportEvent playerTeleportEvent = new PlayerTeleportEvent((Player)this, this.getLocation(), location, cause);
        Bukkit.getPluginManager().callEvent((Event)playerTeleportEvent);
        if (playerTeleportEvent.isCancelled()) {
            return false;
        }
        return super.teleport(playerTeleportEvent.getTo(), cause);
    }

    public void sendEquipmentChange(@NotNull LivingEntity entity, @NotNull EquipmentSlot slot, @NotNull ItemStack item) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity must not be null");
        Preconditions.checkNotNull((Object)slot, (Object)"slot must not be null");
        Preconditions.checkNotNull((Object)item, (Object)"item must not be null");
    }

    @Override
    public boolean isInRain() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isInBubbleColumn() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isInWaterOrRain() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isInWaterOrBubbleColumn() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isInLava() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isTicking() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void registerAttribute(@NotNull Attribute attribute) {
        throw new UnimplementedOperationException();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Player.Spigot spigot() {
        return this.playerSpigotMock;
    }

    public class PlayerSpigotMock
    extends Player.Spigot {
        @Deprecated
        public void sendMessage(BaseComponent ... components) {
            for (BaseComponent component : components) {
                this.sendMessage(component);
            }
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, BaseComponent ... components) {
            for (BaseComponent component : components) {
                this.sendMessage(position, component);
            }
        }

        @Deprecated
        public void sendMessage(@NotNull BaseComponent component) {
            this.sendMessage(ChatMessageType.CHAT, component);
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, @NotNull BaseComponent component) {
            Preconditions.checkNotNull((Object)position, (Object)"Position must not be null");
            Preconditions.checkNotNull((Object)component, (Object)"Component must not be null");
            Component comp = BungeeComponentSerializer.get().deserialize(new BaseComponent[]{component});
            PlayerMock.this.sendMessage(comp);
        }
    }
}

