/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import be.seeseemelk.mockbukkit.entity.VehicleMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Minecart;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MinecartMock
extends VehicleMock
implements Minecart {
    private double damage = 0.0;
    private double maxSpeed = 0.4;
    private boolean slowWhenEmpty = true;
    private Vector flyingVelocityMod = new Vector((double)0.95f, (double)0.95f, (double)0.95f);
    private Vector derailedVelocityMod = new Vector(0.5, 0.5, 0.5);
    private BlockData displayBlock;
    private int displayBlockOffset;

    protected MinecartMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        this.maxSpeed = speed;
    }

    public boolean isSlowWhenEmpty() {
        return this.slowWhenEmpty;
    }

    public void setSlowWhenEmpty(boolean slow) {
        this.slowWhenEmpty = slow;
    }

    @NotNull
    public Vector getFlyingVelocityMod() {
        return this.flyingVelocityMod.clone();
    }

    public void setFlyingVelocityMod(@NotNull Vector flying) {
        Preconditions.checkNotNull((Object)flying, (Object)"Vector cannot be null");
        this.flyingVelocityMod = flying.clone();
    }

    @NotNull
    public Vector getDerailedVelocityMod() {
        return this.derailedVelocityMod.clone();
    }

    public void setDerailedVelocityMod(@NotNull Vector derailed) {
        Preconditions.checkNotNull((Object)derailed, (Object)"Vector cannot be null");
        this.derailedVelocityMod = derailed.clone();
    }

    public void setDisplayBlock(@Nullable MaterialData material) {
        this.displayBlock = material == null ? new BlockDataMock(Material.AIR) : BlockDataMock.mock(material.getItemType());
    }

    @NotNull
    public MaterialData getDisplayBlock() {
        return new MaterialData(this.displayBlock.getMaterial());
    }

    public void setDisplayBlockData(@Nullable BlockData blockData) {
        this.displayBlock = blockData == null ? new BlockDataMock(Material.AIR) : blockData;
    }

    @NotNull
    public BlockData getDisplayBlockData() {
        return this.displayBlock;
    }

    public void setDisplayBlockOffset(int offset) {
        this.displayBlockOffset = offset;
    }

    public int getDisplayBlockOffset() {
        return this.displayBlockOffset;
    }
}

