/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.jetbrains.annotations.NotNull;

public class HangingMock
extends EntityMock
implements Hanging {
    private BlockFace facing;

    public HangingMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @NotNull
    public BlockFace getAttachedFace() {
        return this.getFacing().getOppositeFace();
    }

    public void setFacingDirection(@NotNull BlockFace face) {
        this.setFacingDirection(face, false);
    }

    public boolean setFacingDirection(@NotNull BlockFace face, boolean force) {
        Preconditions.checkNotNull((Object)face);
        Preconditions.checkArgument((face.isCartesian() && face != BlockFace.UP && face != BlockFace.DOWN ? 1 : 0) != 0);
        this.facing = face;
        return true;
    }

    @Override
    @NotNull
    public BlockFace getFacing() {
        return this.facing;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.UNKNOWN;
    }

    public String toString() {
        return "HangingMock";
    }
}

