/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.ProjectileMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishHookMock
extends ProjectileMock
implements FishHook {
    private int minWaitTime = 100;
    private int maxWaitTime = 600;
    private boolean applyLure = true;
    private double biteChance = -1.0;
    private Entity hookedEntity;
    private FishHook.HookState state = FishHook.HookState.UNHOOKED;

    public FishHookMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public int getMinWaitTime() {
        return this.minWaitTime;
    }

    public void setMinWaitTime(int minWaitTime) {
        Preconditions.checkArgument((minWaitTime >= 0 && minWaitTime <= this.getMaxWaitTime() ? 1 : 0) != 0, (Object)"The minimum wait time should be between 0 and the maximum wait time.");
        this.minWaitTime = minWaitTime;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        Preconditions.checkArgument((maxWaitTime >= 0 && maxWaitTime >= this.getMinWaitTime() ? 1 : 0) != 0, (Object)"The maximum wait time should be higher than or equal to 0 and the minimum wait time.");
        this.maxWaitTime = maxWaitTime;
    }

    public boolean getApplyLure() {
        return this.applyLure;
    }

    public void setApplyLure(boolean applyLure) {
        this.applyLure = applyLure;
    }

    public double getBiteChance() {
        if (this.biteChance == -1.0) {
            if (!this.getWorld().isClearWeather()) {
                return 0.0033333333333333335;
            }
            return 0.002;
        }
        return this.biteChance;
    }

    public void setBiteChance(double chance) throws IllegalArgumentException {
        Preconditions.checkArgument((chance >= 0.0 && chance <= 1.0 ? 1 : 0) != 0, (Object)"The bite chance must be between 0 and 1.");
        this.biteChance = chance;
    }

    public boolean isInOpenWater() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Entity getHookedEntity() {
        return this.hookedEntity;
    }

    public void setHookedEntity(@Nullable Entity entity) {
        this.state = FishHook.HookState.HOOKED_ENTITY;
        this.hookedEntity = entity;
    }

    public boolean pullHookedEntity() {
        if (this.hookedEntity == null) {
            return false;
        }
        ProjectileSource projectileSource = this.getShooter();
        if (projectileSource instanceof Entity) {
            Entity shooter = (Entity)projectileSource;
            Location shooterLoc = shooter.getLocation();
            Location hookLoc = this.getLocation();
            Vector velocity = new Vector(shooterLoc.getX() - hookLoc.getX(), shooterLoc.getY() - hookLoc.getY(), shooterLoc.getZ() - hookLoc.getZ()).multiply(0.1);
            this.hookedEntity.setVelocity(this.hookedEntity.getVelocity().add(velocity));
        }
        return true;
    }

    public void updateState() {
        this.state = this.hookedEntity != null ? FishHook.HookState.HOOKED_ENTITY : (this.getLocation().getBlock().isLiquid() ? FishHook.HookState.BOBBING : FishHook.HookState.UNHOOKED);
    }

    @NotNull
    public FishHook.HookState getState() {
        return this.state;
    }

    public int getWaitTime() {
        throw new UnsupportedOperationException();
    }

    public void setWaitTime(int ticks) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.FISHING_HOOK;
    }

    @Override
    @NotNull
    public SpawnCategory getSpawnCategory() {
        return SpawnCategory.MISC;
    }

    public String toString() {
        return "FishingHookMock";
    }
}

