/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.AsyncCatcher;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedTransferQueue;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.PermissionRemovedExecutor;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public abstract class EntityMock
extends Entity.Spigot
implements Entity,
MessageTarget {
    private final ServerMock server;
    private final UUID uuid;
    private Location location;
    private boolean teleported;
    private PlayerTeleportEvent.TeleportCause teleportCause;
    private final MetadataTable metadataTable = new MetadataTable();
    private final PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();
    private boolean operator = false;
    private Component name = Component.text((String)"entity");
    private Component customName = null;
    private boolean customNameVisible = false;
    private boolean invulnerable;
    private boolean glowingFlag = false;
    private final Queue<Component> messages = new LinkedTransferQueue<Component>();
    private final Set<PermissionAttachment> permissionAttachments = new HashSet<PermissionAttachment>();
    private Vector velocity = new Vector(0, 0, 0);
    private float fallDistance;
    private int fireTicks = -20;
    private int maxFireTicks = 20;
    private boolean removed = false;
    private EntityDamageEvent lastDamageEvent;

    protected EntityMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)((Object)server), (Object)"Server cannot be null");
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID cannot be null");
        this.server = server;
        this.uuid = uuid;
        this.location = !Bukkit.getWorlds().isEmpty() ? ((World)Bukkit.getWorlds().get(0)).getSpawnLocation() : new Location(null, 0.0, 0.0, 0.0);
    }

    public final int hashCode() {
        return this.uuid.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof EntityMock) {
            return this.uuid.equals(((EntityMock)obj).getUniqueId());
        }
        return false;
    }

    public void assertLocation(Location expectedLocation, double maximumDistance) {
        double distance = this.location.distance(expectedLocation);
        Assertions.assertEquals((Object)expectedLocation.getWorld(), (Object)this.location.getWorld());
        Assertions.assertTrue((distance <= maximumDistance ? 1 : 0) != 0, (String)String.format("Distance was <%.3f> but should be less than or equal to <%.3f>", distance, maximumDistance));
    }

    public void assertTeleported(@NotNull Location expectedLocation, double maximumDistance) {
        Assertions.assertTrue((boolean)this.teleported, (String)"Player did not teleport");
        this.assertLocation(expectedLocation, maximumDistance);
        this.teleported = false;
    }

    public void assertNotTeleported() {
        Assertions.assertFalse((boolean)this.teleported, (String)"Player was teleported");
        this.teleported = false;
    }

    public boolean hasTeleported() {
        return this.teleported;
    }

    public void clearTeleported() {
        this.teleported = false;
    }

    public PlayerTeleportEvent.TeleportCause getTeleportCause() {
        return this.teleportCause;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uuid;
    }

    @NotNull
    public Location getLocation() {
        return this.location.clone();
    }

    @NotNull
    public Set<Player> getTrackedPlayers() {
        throw new UnimplementedOperationException();
    }

    public Location getLocation(@Nullable Location loc) {
        if (loc == null) {
            return null;
        }
        loc.setWorld(this.location.getWorld());
        loc.setDirection(this.location.getDirection());
        loc.setX(this.location.getX());
        loc.setY(this.location.getY());
        loc.setZ(this.location.getZ());
        return loc;
    }

    public void setLocation(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        this.location = location;
    }

    @NotNull
    public World getWorld() {
        return this.location.getWorld();
    }

    public void setMetadata(@NotNull String metadataKey, @NotNull MetadataValue newMetadataValue) {
        Preconditions.checkNotNull((Object)metadataKey, (Object)"Metadata key cannot be null");
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    @NotNull
    public List<MetadataValue> getMetadata(@NotNull String metadataKey) {
        Preconditions.checkNotNull((Object)metadataKey, (Object)"Metadata key cannot be null");
        return this.metadataTable.getMetadata(metadataKey);
    }

    public boolean hasMetadata(@NotNull String metadataKey) {
        Preconditions.checkNotNull((Object)metadataKey, (Object)"Metadata key cannot be null");
        return this.metadataTable.hasMetadata(metadataKey);
    }

    public void removeMetadata(@NotNull String metadataKey, @NotNull Plugin owningPlugin) {
        Preconditions.checkNotNull((Object)metadataKey, (Object)"Metadata key cannot be null");
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public boolean teleport(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(@NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        this.location = location;
        this.teleported = true;
        this.teleportCause = cause;
        return true;
    }

    public boolean teleport(@NotNull Entity destination) {
        Preconditions.checkNotNull((Object)destination, (Object)"Destination entity cannot be null");
        return this.teleport(destination, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(@NotNull Entity destination, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkNotNull((Object)destination, (Object)"Destination entity cannot be null");
        Preconditions.checkNotNull((Object)cause, (Object)"TeleportCause cannot be null");
        return this.teleport(destination.getLocation(), cause);
    }

    public boolean isOp() {
        return this.operator;
    }

    public void setOp(boolean isOperator) {
        this.operator = isOperator;
    }

    @NotNull
    public String getName() {
        return LegacyComponentSerializer.legacySection().serialize(this.name);
    }

    public void setName(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.name = LegacyComponentSerializer.legacySection().deserialize(name);
    }

    public void sendMessage(@NotNull String message) {
        this.sendMessage((UUID)null, message);
    }

    public void sendMessage(String ... messages) {
        this.sendMessage((UUID)null, messages);
    }

    public void sendMessage(@Nullable UUID sender, @NotNull String message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
        this.sendMessage(sender == null ? Identity.nil() : Identity.identity((UUID)sender), (Component)LegacyComponentSerializer.legacySection().deserialize(message), MessageType.SYSTEM);
    }

    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public void sendMessage(@NotNull Identity source, @NotNull Component message, @NotNull MessageType type) {
        Preconditions.checkNotNull((Object)source, (Object)"Source cannot be null");
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
        Preconditions.checkNotNull((Object)type, (Object)"MessageType cannot be null");
        this.messages.add(message);
    }

    @Override
    @Nullable
    public String nextMessage() {
        if (this.messages.peek() == null) {
            return null;
        }
        return LegacyComponentSerializer.legacySection().serialize(this.messages.poll());
    }

    @Nullable
    public Component nextComponentMessage() {
        return this.messages.poll();
    }

    public boolean isPermissionSet(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        return this.permissionAttachments.stream().map(PermissionAttachment::getPermissions).anyMatch(permissions -> permissions.containsKey(name) && (Boolean)permissions.get(name) != false);
    }

    public boolean isPermissionSet(@NotNull Permission perm) {
        Preconditions.checkNotNull((Object)perm, (Object)"Permission cannot be null");
        return this.isPermissionSet(perm.getName().toLowerCase(Locale.ENGLISH));
    }

    public boolean hasPermission(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        if (this.isPermissionSet(name)) {
            return true;
        }
        Permission perm = this.server.getPluginManager().getPermission(name);
        return perm != null ? this.hasPermission(perm) : Permission.DEFAULT_PERMISSION.getValue(this.isOp());
    }

    public boolean hasPermission(@NotNull Permission perm) {
        Preconditions.checkNotNull((Object)perm, (Object)"Permission cannot be null");
        return this.isPermissionSet(perm) || perm.getDefault().getValue(this.isOp());
    }

    @NotNull
    public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String name, boolean value) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        PermissionAttachment attachment = this.addAttachment(plugin);
        attachment.setPermission(name, value);
        return attachment;
    }

    @NotNull
    public PermissionAttachment addAttachment(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        PermissionAttachment attachment = new PermissionAttachment(plugin, (Permissible)this);
        this.permissionAttachments.add(attachment);
        return attachment;
    }

    public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String name, boolean value, int ticks) {
        throw new UnimplementedOperationException();
    }

    public PermissionAttachment addAttachment(@NotNull Plugin plugin, int ticks) {
        throw new UnimplementedOperationException();
    }

    public void removeAttachment(@NotNull PermissionAttachment attachment) {
        Preconditions.checkNotNull((Object)attachment, (Object)"Attachment cannot be null");
        if (this.permissionAttachments.contains(attachment)) {
            this.permissionAttachments.remove(attachment);
            PermissionRemovedExecutor ex = attachment.getRemovalCallback();
            if (ex != null) {
                ex.attachmentRemoved(attachment);
            }
        } else {
            throw new IllegalArgumentException("Given attachment is not part of Permissible object " + this);
        }
        this.recalculatePermissions();
    }

    public void recalculatePermissions() {
    }

    @NotNull
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        HashSet<PermissionAttachmentInfo> permissionAttachmentInfos = new HashSet<PermissionAttachmentInfo>();
        for (PermissionAttachment permissionAttachment : this.permissionAttachments) {
            for (Map.Entry entry : permissionAttachment.getPermissions().entrySet()) {
                permissionAttachmentInfos.add(new PermissionAttachmentInfo((Permissible)this, (String)entry.getKey(), permissionAttachment, ((Boolean)entry.getValue()).booleanValue()));
            }
        }
        return permissionAttachmentInfos;
    }

    @Nullable
    public Component customName() {
        return this.customName;
    }

    public void customName(@Nullable Component customName) {
        this.customName = customName;
    }

    public String getCustomName() {
        return this.customName == null ? null : LegacyComponentSerializer.legacySection().serialize(this.customName);
    }

    public void setCustomName(@Nullable String name) {
        this.customName = name == null ? null : LegacyComponentSerializer.legacySection().deserialize(name);
    }

    public void setVelocity(@NotNull Vector velocity) {
        Preconditions.checkNotNull((Object)velocity, (Object)"Velocity cannot be null");
        this.velocity = velocity;
    }

    @NotNull
    public Vector getVelocity() {
        return this.velocity;
    }

    public double getHeight() {
        throw new UnimplementedOperationException();
    }

    public double getWidth() {
        throw new UnimplementedOperationException();
    }

    public boolean isOnGround() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<Entity> getNearbyEntities(double x, double y, double z) {
        AsyncCatcher.catchOp("getNearbyEntities");
        throw new UnimplementedOperationException();
    }

    public int getEntityId() {
        throw new UnimplementedOperationException();
    }

    public int getFireTicks() {
        return this.fireTicks;
    }

    public int getMaxFireTicks() {
        return this.maxFireTicks;
    }

    public void setFireTicks(int ticks) {
        this.fireTicks = ticks;
    }

    public void setVisualFire(boolean fire) {
        throw new UnimplementedOperationException();
    }

    public boolean isVisualFire() {
        throw new UnimplementedOperationException();
    }

    public void setFreezeTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    public boolean isFrozen() {
        throw new UnimplementedOperationException();
    }

    public boolean isFreezeTickingLocked() {
        throw new UnimplementedOperationException();
    }

    public void lockFreezeTicks(boolean locked) {
        throw new UnimplementedOperationException();
    }

    public int getFreezeTicks() {
        throw new UnimplementedOperationException();
    }

    public int getMaxFreezeTicks() {
        throw new UnimplementedOperationException();
    }

    public void remove() {
        this.removed = true;
    }

    public boolean isDead() {
        return !this.removed;
    }

    public boolean isValid() {
        return !this.removed;
    }

    @NotNull
    public ServerMock getServer() {
        return this.server;
    }

    @Deprecated
    public Entity getPassenger() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean setPassenger(@NotNull Entity passenger) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public List<Entity> getPassengers() {
        throw new UnimplementedOperationException();
    }

    public boolean addPassenger(@NotNull Entity passenger) {
        throw new UnimplementedOperationException();
    }

    public boolean removePassenger(@NotNull Entity passenger) {
        throw new UnimplementedOperationException();
    }

    public boolean isEmpty() {
        throw new UnimplementedOperationException();
    }

    public boolean eject() {
        throw new UnimplementedOperationException();
    }

    public float getFallDistance() {
        return this.fallDistance;
    }

    public void setFallDistance(float distance) {
        this.fallDistance = distance;
    }

    public void setLastDamageCause(@Nullable EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    @Nullable
    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    public int getTicksLived() {
        throw new UnimplementedOperationException();
    }

    public void setTicksLived(int value) {
        throw new UnimplementedOperationException();
    }

    public void playEffect(@NotNull EntityEffect type) {
        Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null");
    }

    @NotNull
    public EntityType getType() {
        return EntityType.UNKNOWN;
    }

    public boolean isInsideVehicle() {
        throw new UnimplementedOperationException();
    }

    public boolean leaveVehicle() {
        throw new UnimplementedOperationException();
    }

    public Entity getVehicle() {
        throw new UnimplementedOperationException();
    }

    public void setCustomNameVisible(boolean flag) {
        this.customNameVisible = flag;
    }

    public boolean isCustomNameVisible() {
        return this.customNameVisible;
    }

    public void setGlowing(boolean flag) {
        this.glowingFlag = flag;
    }

    public boolean isGlowing() {
        return this.glowingFlag;
    }

    public void setInvulnerable(boolean flag) {
        this.invulnerable = flag;
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public boolean isSilent() {
        throw new UnimplementedOperationException();
    }

    public void setSilent(boolean flag) {
        throw new UnimplementedOperationException();
    }

    public boolean hasGravity() {
        throw new UnimplementedOperationException();
    }

    public void setGravity(boolean gravity) {
        throw new UnimplementedOperationException();
    }

    public int getPortalCooldown() {
        throw new UnimplementedOperationException();
    }

    public void setPortalCooldown(int cooldown) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<String> getScoreboardTags() {
        throw new UnimplementedOperationException();
    }

    public boolean addScoreboardTag(@NotNull String tag) {
        throw new UnimplementedOperationException();
    }

    public boolean removeScoreboardTag(@NotNull String tag) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnimplementedOperationException();
    }

    public void setRotation(float yaw, float pitch) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    public boolean isPersistent() {
        throw new UnimplementedOperationException();
    }

    public void setPersistent(boolean persistent) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockFace getFacing() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Pose getPose() {
        throw new UnimplementedOperationException();
    }

    public boolean isInWater() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public SpawnCategory getSpawnCategory() {
        return SpawnCategory.MISC;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.Spigot spigot() {
        return this;
    }

    @NotNull
    public Component name() {
        return this.name;
    }

    @NotNull
    public Component teamDisplayName() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location getOrigin() {
        throw new UnimplementedOperationException();
    }

    public boolean fromMobSpawner() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Chunk getChunk() {
        return this.getLocation().getChunk();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreatureSpawnEvent.SpawnReason getEntitySpawnReason() {
        throw new UnimplementedOperationException();
    }

    public boolean isInRain() {
        throw new UnimplementedOperationException();
    }

    public boolean isInBubbleColumn() {
        throw new UnimplementedOperationException();
    }

    public boolean isInWaterOrRain() {
        throw new UnimplementedOperationException();
    }

    public boolean isInWaterOrBubbleColumn() {
        throw new UnimplementedOperationException();
    }

    public boolean isInWaterOrRainOrBubbleColumn() {
        throw new UnimplementedOperationException();
    }

    public boolean isInLava() {
        throw new UnimplementedOperationException();
    }

    public boolean isTicking() {
        throw new UnimplementedOperationException();
    }

    public boolean spawnAt(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    public boolean spawnAt(@NotNull Location location, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreatureSpawnEvent.SpawnReason reason) {
        throw new UnimplementedOperationException();
    }

    public boolean isInPowderedSnow() {
        throw new UnimplementedOperationException();
    }
}

