/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.LivingEntityMock;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityEquipmentMock
implements EntityEquipment {
    private final LivingEntityMock holder;
    private final Map<EquipmentSlot, Float> dropChances = new EnumMap<EquipmentSlot, Float>(EquipmentSlot.class);
    private ItemStack itemInMainHand = new ItemStack(Material.AIR);
    private ItemStack itemInOffHand = new ItemStack(Material.AIR);
    private ItemStack helmet = new ItemStack(Material.AIR);
    private ItemStack chestPlate = new ItemStack(Material.AIR);
    private ItemStack leggings = new ItemStack(Material.AIR);
    private ItemStack boots = new ItemStack(Material.AIR);

    public EntityEquipmentMock(@NotNull LivingEntityMock holder) {
        Preconditions.checkNotNull((Object)holder, (Object)"Holder cannot be null");
        this.holder = holder;
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        Preconditions.checkNotNull((Object)slot, (Object)"Slot cannot be null");
        this.setItem(slot, item, false);
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item, boolean silent) {
        Preconditions.checkNotNull((Object)slot, (Object)"Slot cannot be null");
        switch (slot) {
            case HEAD: {
                this.setHelmet(item, silent);
                break;
            }
            case CHEST: {
                this.setChestplate(item, silent);
                break;
            }
            case LEGS: {
                this.setLeggings(item, silent);
                break;
            }
            case FEET: {
                this.setBoots(item, silent);
                break;
            }
            case HAND: {
                this.setItemInMainHand(item, silent);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item, silent);
                break;
            }
            default: {
                throw new UnimplementedOperationException("EquipmentSlot '" + slot + "' has no implementation!");
            }
        }
    }

    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot slot) {
        Preconditions.checkNotNull((Object)slot, (Object)"Slot cannot be null");
        return switch (slot) {
            case EquipmentSlot.CHEST -> this.getChestplate();
            case EquipmentSlot.FEET -> this.getBoots();
            case EquipmentSlot.HAND -> this.getItemInMainHand();
            case EquipmentSlot.HEAD -> this.getHelmet();
            case EquipmentSlot.LEGS -> this.getLeggings();
            case EquipmentSlot.OFF_HAND -> this.getItemInOffHand();
            default -> throw new UnimplementedOperationException("EquipmentSlot '" + slot + "' has no implementation!");
        };
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        return this.itemInMainHand;
    }

    public void setItemInMainHand(@Nullable ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    public void setItemInMainHand(@Nullable ItemStack item, boolean silent) {
        this.itemInMainHand = item;
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        return this.itemInOffHand;
    }

    public void setItemInOffHand(@Nullable ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    public void setItemInOffHand(@Nullable ItemStack item, boolean silent) {
        this.itemInOffHand = item;
    }

    @Deprecated
    @NotNull
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Deprecated
    public void setItemInHand(@Nullable ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public void setHelmet(@Nullable ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    public void setHelmet(@Nullable ItemStack helmet, boolean silent) {
        this.helmet = helmet;
    }

    public ItemStack getChestplate() {
        return this.chestPlate;
    }

    public void setChestplate(@Nullable ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    public void setChestplate(@Nullable ItemStack chestplate, boolean silent) {
        this.chestPlate = chestplate;
    }

    public ItemStack getLeggings() {
        return this.leggings;
    }

    public void setLeggings(@Nullable ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    public void setLeggings(@Nullable ItemStack leggings, boolean silent) {
        this.leggings = leggings;
    }

    public ItemStack getBoots() {
        return this.boots;
    }

    public void setBoots(@Nullable ItemStack boots) {
        this.setBoots(boots, false);
    }

    public void setBoots(@Nullable ItemStack boots, boolean silent) {
        this.boots = boots;
    }

    public ItemStack @NotNull [] getArmorContents() {
        return new ItemStack[]{this.getBoots(), this.getLeggings(), this.getChestplate(), this.getHelmet()};
    }

    public void setArmorContents(@NotNull ItemStack[] items) {
        Preconditions.checkNotNull((Object)items, (Object)"Items cannot be null");
        this.setBoots(items.length >= 1 ? items[0] : null);
        this.setLeggings(items.length >= 2 ? items[1] : null);
        this.setChestplate(items.length >= 3 ? items[2] : null);
        this.setHelmet(items.length >= 4 ? items[3] : null);
    }

    public void clear() {
        this.setItemInMainHand(null);
        this.setItemInOffHand(null);
        this.setHelmet(null);
        this.setChestplate(null);
        this.setLeggings(null);
        this.setBoots(null);
    }

    @Deprecated
    public float getItemInHandDropChance() {
        return this.dropChances.get(EquipmentSlot.HAND).floatValue();
    }

    @Deprecated
    public void setItemInHandDropChance(float chance) {
        this.setDropChance(EquipmentSlot.HAND, chance);
    }

    public float getItemInMainHandDropChance() {
        return this.dropChances.get(EquipmentSlot.HAND).floatValue();
    }

    public void setItemInMainHandDropChance(float chance) {
        this.setDropChance(EquipmentSlot.HAND, chance);
    }

    public float getItemInOffHandDropChance() {
        return this.dropChances.get(EquipmentSlot.OFF_HAND).floatValue();
    }

    public void setItemInOffHandDropChance(float chance) {
        this.setDropChance(EquipmentSlot.OFF_HAND, chance);
    }

    public float getHelmetDropChance() {
        return this.dropChances.get(EquipmentSlot.HEAD).floatValue();
    }

    public void setHelmetDropChance(float chance) {
        this.setDropChance(EquipmentSlot.HEAD, chance);
    }

    public float getChestplateDropChance() {
        return this.dropChances.get(EquipmentSlot.CHEST).floatValue();
    }

    public void setChestplateDropChance(float chance) {
        this.setDropChance(EquipmentSlot.CHEST, chance);
    }

    public float getLeggingsDropChance() {
        return this.dropChances.get(EquipmentSlot.LEGS).floatValue();
    }

    public void setLeggingsDropChance(float chance) {
        this.setDropChance(EquipmentSlot.LEGS, chance);
    }

    public float getBootsDropChance() {
        return this.dropChances.get(EquipmentSlot.FEET).floatValue();
    }

    public void setBootsDropChance(float chance) {
        this.setDropChance(EquipmentSlot.FEET, chance);
    }

    public Entity getHolder() {
        return this.holder;
    }

    public void setDropChance(@NotNull EquipmentSlot slot, float chance) {
        Preconditions.checkNotNull((Object)slot, (Object)"Slot cannot be null");
        Preconditions.checkArgument((boolean)(this.holder instanceof Mob), (Object)"Cannot set drop chance for non-Mob entity");
        this.dropChances.put(slot, Float.valueOf(chance));
    }

    public float getDropChance(@NotNull EquipmentSlot slot) {
        Preconditions.checkNotNull((Object)slot, (Object)"Slot cannot be null");
        return this.dropChances.get(slot).floatValue();
    }
}

