/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.AgeableMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Animals;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalsMock
extends AgeableMock
implements Animals {
    private UUID breedCause;
    private int isInLoveTicks;

    public AnimalsMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public UUID getBreedCause() {
        return this.breedCause;
    }

    public void setBreedCause(@Nullable UUID uuid) {
        this.breedCause = uuid;
    }

    public boolean isLoveMode() {
        return this.isInLoveTicks > 0;
    }

    public void setLoveModeTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Love mode ticks must be positive or 0");
        this.isInLoveTicks = ticks;
    }

    public int getLoveModeTicks() {
        return this.isInLoveTicks;
    }

    public boolean isBreedItem(@NotNull ItemStack stack) {
        throw new UnimplementedOperationException();
    }

    public boolean isBreedItem(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        return this.isBreedItem(new ItemStack(material));
    }

    @Override
    @NotNull
    public SpawnCategory getSpawnCategory() {
        return SpawnCategory.ANIMAL;
    }

    @Override
    public String toString() {
        return "AnimalsMock";
    }
}

