/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.boss;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossBarMock
implements BossBar {
    private String title;
    private BarColor color;
    private BarStyle style;
    private final Set<Player> players = new HashSet<Player>();
    private final Set<BarFlag> barFlags = EnumSet.noneOf(BarFlag.class);
    private boolean visible = true;
    private double progress = 1.0;

    public BossBarMock(@NotNull String title, @NotNull BarColor color, @NotNull BarStyle style, BarFlag ... flags) {
        this.title = title;
        this.color = color;
        this.style = style;
        for (BarFlag flag : flags) {
            this.addFlag(flag);
        }
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title == null ? "" : title;
    }

    @NotNull
    public BarColor getColor() {
        return this.color;
    }

    public void setColor(@NotNull BarColor color) {
        this.color = color;
    }

    @NotNull
    public BarStyle getStyle() {
        return this.style;
    }

    public void setStyle(@NotNull BarStyle style) {
        Preconditions.checkNotNull((Object)style, (Object)"Style cannot be null");
        this.style = style;
    }

    public void removeFlag(@NotNull BarFlag flag) {
        Preconditions.checkNotNull((Object)flag, (Object)"Flag cannot be null");
        this.barFlags.remove(flag);
    }

    public void addFlag(@NotNull BarFlag flag) {
        Preconditions.checkNotNull((Object)flag, (Object)"Flag cannot be null");
        this.barFlags.add(flag);
    }

    public boolean hasFlag(@NotNull BarFlag flag) {
        Preconditions.checkNotNull((Object)flag, (Object)"Flag cannot be null");
        return this.barFlags.contains(flag);
    }

    public void setProgress(double progress) {
        if (progress > 1.0 || progress < 0.0) {
            throw new IllegalArgumentException("Progress must be between 0.0 and 1.0");
        }
        this.progress = progress;
    }

    public double getProgress() {
        return this.progress;
    }

    public void addPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.players.add(player);
    }

    public void removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.players.remove(player);
    }

    public void removeAll() {
        this.players.clear();
    }

    @NotNull
    public List<Player> getPlayers() {
        return new ArrayList<Player>(this.players);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Deprecated
    public void show() {
        this.setVisible(true);
    }

    @Deprecated
    public void hide() {
        this.setVisible(false);
    }
}

