/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import com.destroystokyo.paper.MaterialTags;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.jetbrains.annotations.NotNull;

public class SignMock
extends TileStateMock
implements Sign {
    private final String[] lines = new String[]{"", "", "", ""};

    public SignMock(@NotNull Material material) {
        super(material);
        if (!MaterialTags.SIGNS.isTagged(material)) {
            throw new IllegalArgumentException("Cannot create a Sign state from " + material);
        }
    }

    protected SignMock(@NotNull Block block) {
        super(block);
        if (!MaterialTags.SIGNS.isTagged(block)) {
            throw new IllegalArgumentException("Cannot create a Sign state from " + block.getType());
        }
    }

    protected SignMock(@NotNull SignMock state) {
        super(state);
        for (int i = 0; i < 4; ++i) {
            this.lines[i] = state.getLine(i);
        }
    }

    @NotNull
    public List<Component> lines() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (String line : this.lines) {
            components.add((Component)LegacyComponentSerializer.legacySection().deserialize(line));
        }
        return components;
    }

    @NotNull
    public Component line(int index) throws IndexOutOfBoundsException {
        return LegacyComponentSerializer.legacySection().deserialize(this.getLine(index));
    }

    public void line(int index, @NotNull Component line) throws IndexOutOfBoundsException {
        Preconditions.checkNotNull((Object)line, (Object)"Line cannot be null!");
        this.lines[index] = LegacyComponentSerializer.legacySection().serialize(line);
    }

    @Deprecated
    @NotNull
    public String[] getLines() {
        String[] text = new String[4];
        for (int i = 0; i < 4; ++i) {
            text[i] = this.getLine(i);
        }
        return text;
    }

    @Deprecated
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.lines[index];
    }

    @Deprecated
    public void setLine(int index, @NotNull String line) throws IndexOutOfBoundsException {
        Preconditions.checkNotNull((Object)line, (Object)"Line cannot be null!");
        this.lines[index] = line;
    }

    public boolean isEditable() {
        throw new UnimplementedOperationException();
    }

    public void setEditable(boolean editable) {
        throw new UnimplementedOperationException();
    }

    public boolean isGlowingText() {
        throw new UnimplementedOperationException();
    }

    public void setGlowingText(boolean glowing) {
        throw new UnimplementedOperationException();
    }

    public DyeColor getColor() {
        throw new UnimplementedOperationException();
    }

    public void setColor(DyeColor color) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BlockState getSnapshot() {
        return new SignMock(this);
    }
}

