/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.state.ContainerMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import be.seeseemelk.mockbukkit.inventory.ShulkerBoxInventoryMock;
import com.destroystokyo.paper.MaterialTags;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerBoxMock
extends ContainerMock
implements ShulkerBox {
    private final DyeColor color;
    private boolean isOpen = false;

    public ShulkerBoxMock(@NotNull Material material) {
        super(material);
        if (!MaterialTags.SHULKER_BOXES.isTagged(material)) {
            throw new IllegalArgumentException("Cannot create a Shulker Box state from " + material);
        }
        this.color = this.getFromMaterial(material);
    }

    protected ShulkerBoxMock(@NotNull Block block) {
        super(block);
        if (!MaterialTags.SHULKER_BOXES.isTagged(block)) {
            throw new IllegalArgumentException("Cannot create a Shulker Box state from " + block.getType());
        }
        this.color = this.getFromMaterial(block.getType());
    }

    protected ShulkerBoxMock(@NotNull ShulkerBoxMock state) {
        super(state);
        this.color = state.color;
        this.isOpen = state.isOpen;
    }

    @Nullable
    private DyeColor getFromMaterial(@NotNull Material type) {
        Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null");
        switch (type) {
            case SHULKER_BOX: {
                return null;
            }
            case WHITE_SHULKER_BOX: {
                return DyeColor.WHITE;
            }
            case ORANGE_SHULKER_BOX: {
                return DyeColor.ORANGE;
            }
            case MAGENTA_SHULKER_BOX: {
                return DyeColor.MAGENTA;
            }
            case LIGHT_BLUE_SHULKER_BOX: {
                return DyeColor.LIGHT_BLUE;
            }
            case YELLOW_SHULKER_BOX: {
                return DyeColor.YELLOW;
            }
            case LIME_SHULKER_BOX: {
                return DyeColor.LIME;
            }
            case PINK_SHULKER_BOX: {
                return DyeColor.PINK;
            }
            case GRAY_SHULKER_BOX: {
                return DyeColor.GRAY;
            }
            case LIGHT_GRAY_SHULKER_BOX: {
                return DyeColor.LIGHT_GRAY;
            }
            case CYAN_SHULKER_BOX: {
                return DyeColor.CYAN;
            }
            case PURPLE_SHULKER_BOX: {
                return DyeColor.PURPLE;
            }
            case BLUE_SHULKER_BOX: {
                return DyeColor.BLUE;
            }
            case BROWN_SHULKER_BOX: {
                return DyeColor.BROWN;
            }
            case GREEN_SHULKER_BOX: {
                return DyeColor.GREEN;
            }
            case RED_SHULKER_BOX: {
                return DyeColor.RED;
            }
            case BLACK_SHULKER_BOX: {
                return DyeColor.BLACK;
            }
        }
        throw new IllegalArgumentException(type.name() + " is not a Shulker Box!");
    }

    public void setLootTable(LootTable table) {
        throw new UnimplementedOperationException();
    }

    public LootTable getLootTable() {
        throw new UnimplementedOperationException();
    }

    public void setSeed(long seed) {
        throw new UnimplementedOperationException();
    }

    public long getSeed() {
        throw new UnimplementedOperationException();
    }

    public void open() {
        this.isOpen = true;
    }

    public void close() {
        this.isOpen = false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    protected InventoryMock createInventory() {
        return new ShulkerBoxInventoryMock((InventoryHolder)this);
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new ShulkerBoxMock(this);
    }

    @NotNull
    public DyeColor getColor() {
        if (this.color == null) {
            throw new NullPointerException("This Shulker Box has not been dyed");
        }
        return this.color;
    }

    public boolean isRefillEnabled() {
        throw new UnimplementedOperationException();
    }

    public boolean hasBeenFilled() {
        throw new UnimplementedOperationException();
    }

    public boolean hasPlayerLooted(@NotNull UUID player) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Long getLastLooted(@NotNull UUID player) {
        throw new UnimplementedOperationException();
    }

    public boolean setHasPlayerLooted(@NotNull UUID player, boolean looted) {
        throw new UnimplementedOperationException();
    }

    public boolean hasPendingRefill() {
        throw new UnimplementedOperationException();
    }

    public long getLastFilled() {
        throw new UnimplementedOperationException();
    }

    public long getNextRefill() {
        throw new UnimplementedOperationException();
    }

    public long setNextRefill(long refillAt) {
        throw new UnimplementedOperationException();
    }
}

