/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import org.apache.commons.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Campfire;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CampfireMock
extends TileStateMock
implements Campfire {
    private static final int MAX_SLOTS = 4;
    private ItemStack[] items = new ItemStack[4];
    private int[] cookingProgress = new int[4];
    private int[] cookingTime = new int[4];
    private boolean[] cookingDisabled = new boolean[4];

    public CampfireMock(@NotNull Material material) {
        super(material);
        if (material != Material.CAMPFIRE && material != Material.SOUL_CAMPFIRE) {
            throw new IllegalArgumentException("Cannot create a Campfire state from " + material);
        }
    }

    protected CampfireMock(@NotNull Block block) {
        super(block);
        if (block.getType() != Material.CAMPFIRE && block.getType() != Material.SOUL_CAMPFIRE) {
            throw new IllegalArgumentException("Cannot create a Campfire state from " + block.getType());
        }
    }

    protected CampfireMock(@NotNull CampfireMock state) {
        super(state);
        this.items = (ItemStack[])state.items.clone();
        this.cookingProgress = (int[])state.cookingProgress.clone();
        this.cookingTime = (int[])state.cookingTime.clone();
        this.cookingDisabled = (boolean[])state.cookingDisabled.clone();
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new CampfireMock(this);
    }

    public int getSize() {
        return 4;
    }

    @Nullable
    public ItemStack getItem(int index) {
        CampfireMock.checkSlot(index);
        return this.items[index];
    }

    public void setItem(int index, @Nullable ItemStack item) {
        CampfireMock.checkSlot(index);
        this.items[index] = item;
    }

    public int getCookTime(int index) {
        CampfireMock.checkSlot(index);
        return this.cookingTime[index];
    }

    public void setCookTime(int index, int cookTime) {
        CampfireMock.checkSlot(index);
        this.cookingTime[index] = cookTime;
    }

    public int getCookTimeTotal(int index) {
        CampfireMock.checkSlot(index);
        return this.cookingProgress[index];
    }

    public void setCookTimeTotal(int index, int cookTimeTotal) {
        CampfireMock.checkSlot(index);
        this.cookingProgress[index] = cookTimeTotal;
    }

    public void stopCooking() {
        for (int i = 0; i < this.cookingDisabled.length; ++i) {
            this.stopCooking(i);
        }
    }

    public void startCooking() {
        for (int i = 0; i < this.cookingDisabled.length; ++i) {
            this.startCooking(i);
        }
    }

    public boolean stopCooking(int index) {
        CampfireMock.checkSlot(index);
        boolean previous = this.isCookingDisabled(index);
        this.cookingDisabled[index] = true;
        return previous;
    }

    public boolean startCooking(int index) {
        CampfireMock.checkSlot(index);
        boolean previous = this.isCookingDisabled(index);
        this.cookingDisabled[index] = false;
        return previous;
    }

    public boolean isCookingDisabled(int index) {
        CampfireMock.checkSlot(index);
        return this.cookingDisabled[index];
    }

    private static void checkSlot(int index) {
        int maxSlots = 3;
        Validate.isTrue((index >= 0 && index <= maxSlots ? 1 : 0) != 0, (String)("Slot index must be between 0 and " + maxSlots + " (inclusive)"), (Object[])new Object[0]);
    }
}

