/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Beehive;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Bee;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeehiveMock
extends TileStateMock
implements Beehive {
    private Location flowerLocation;
    private int maxBees = 3;
    private boolean sedated;
    private final List<Bee> bees = new ArrayList<Bee>();

    public BeehiveMock(@NotNull Material material) {
        super(material);
        if (material != Material.BEEHIVE) {
            throw new IllegalArgumentException("Cannot create a Beehive state from " + material);
        }
    }

    protected BeehiveMock(@NotNull Block block) {
        super(block);
        if (block.getType() != Material.BEEHIVE) {
            throw new IllegalArgumentException("Cannot create a Beehive state from " + block.getType());
        }
    }

    protected BeehiveMock(@NotNull BeehiveMock state) {
        super(state);
        this.flowerLocation = state.flowerLocation;
        this.maxBees = state.maxBees;
        this.sedated = state.sedated;
        this.bees.addAll(state.bees);
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new BeehiveMock(this);
    }

    @Nullable
    public Location getFlower() {
        return this.flowerLocation;
    }

    public void setFlower(@Nullable Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in the same world");
        this.flowerLocation = location;
    }

    public void setSedated(boolean sedated) {
        this.sedated = sedated;
    }

    public void updateSedated() {
        throw new UnimplementedOperationException("Campfires aren't implemented yet.");
    }

    public boolean isSedated() {
        return this.sedated;
    }

    public boolean isFull() {
        return this.bees.size() == this.maxBees;
    }

    public int getEntityCount() {
        return this.bees.size();
    }

    public int getMaxEntities() {
        return this.maxBees;
    }

    public void setMaxEntities(int max) {
        Preconditions.checkArgument((max > 0 ? 1 : 0) != 0, (Object)"Max bees must be more than 0");
        this.maxBees = max;
    }

    @NotNull
    public List<Bee> releaseEntities() {
        throw new UnimplementedOperationException();
    }

    public void addEntity(@NotNull Bee entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity must not be null");
        throw new UnimplementedOperationException();
    }

    public void clearEntities() {
        this.bees.clear();
    }
}

