/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.banner.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BannerMock
extends TileStateMock
implements Banner {
    private DyeColor baseColor;
    private List<Pattern> patterns = new ArrayList<Pattern>();
    private Component customName;

    public BannerMock(@NotNull Material material) {
        super(material);
        if (!Tag.BANNERS.isTagged((Keyed)material)) {
            throw new IllegalArgumentException("Cannot create a Banner state from " + material.name());
        }
    }

    protected BannerMock(@NotNull Block block) {
        super(block);
        if (!Tag.BANNERS.isTagged((Keyed)block.getType())) {
            throw new IllegalArgumentException("Cannot create a Banner state from " + block.getType().name());
        }
    }

    protected BannerMock(@NotNull BannerMock state) {
        super(state);
        this.baseColor = state.baseColor;
        this.patterns.addAll(state.patterns);
        this.customName = state.customName;
    }

    @Override
    @NotNull
    public BannerMock getSnapshot() {
        return new BannerMock(this);
    }

    @NotNull
    public DyeColor getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(@NotNull DyeColor color) {
        Preconditions.checkNotNull((Object)color, (Object)"Color cannot be null");
        this.baseColor = color;
    }

    @NotNull
    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    public void setPatterns(@NotNull List<Pattern> patterns) {
        Preconditions.checkNotNull(patterns, (Object)"Patterns cannot be null");
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    public void addPattern(@NotNull Pattern pattern) {
        Preconditions.checkNotNull((Object)pattern, (Object)"Pattern cannot be null");
        this.patterns.add(pattern);
    }

    @NotNull
    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    @NotNull
    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    public void setPattern(int i, @NotNull Pattern pattern) {
        Preconditions.checkNotNull((Object)pattern, (Object)"Pattern cannot be null");
        this.patterns.set(i, pattern);
    }

    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Nullable
    public Component customName() {
        return this.customName;
    }

    public void customName(@Nullable Component customName) {
        this.customName = customName;
    }

    @Nullable
    public String getCustomName() {
        return this.customName == null ? null : LegacyComponentSerializer.legacySection().serialize(this.customName);
    }

    public void setCustomName(@Nullable String name) {
        this.customName = name == null ? null : LegacyComponentSerializer.legacySection().deserialize(name);
    }
}

