/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.data.AmethystClusterMock;
import be.seeseemelk.mockbukkit.block.data.BedMock;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.Tag;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockDataMock
implements BlockData {
    private final Material type;
    private final Map<String, Object> data;

    public BlockDataMock(@NotNull Material type) {
        Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null");
        this.type = type;
        this.data = new LinkedHashMap<String, Object>();
    }

    protected <T> void set(@NotNull String key, T value) {
        this.data.put(key, value);
    }

    protected <T> T get(@NotNull String key) {
        Object value = this.data.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Cannot get property " + key + " as it does not exist.");
        }
        return (T)value;
    }

    @NotNull
    public Material getMaterial() {
        return this.type;
    }

    @NotNull
    public String getAsString() {
        StringBuilder stateString = new StringBuilder("minecraft:" + this.getMaterial().name().toLowerCase());
        if (!this.data.isEmpty()) {
            stateString.append('[');
            stateString.append(this.data.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue().toString().toLowerCase()).collect(Collectors.joining(",")));
            stateString.append(']');
        }
        return stateString.toString();
    }

    @NotNull
    public String getAsString(boolean hideUnspecified) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockData merge(@NotNull BlockData data) {
        Preconditions.checkNotNull((Object)data, (Object)"Data cannot be null");
        BlockDataMock mock = (BlockDataMock)this.clone();
        mock.data.putAll(((BlockDataMock)data).data);
        return mock;
    }

    public SoundGroup getSoundGroup() {
        throw new UnimplementedOperationException();
    }

    public boolean matches(@Nullable BlockData data) {
        if (data == null || data.getMaterial() != this.type) {
            return false;
        }
        boolean matches = this.equals(data);
        if (!matches) {
            return this.merge(data).equals(this);
        }
        return matches;
    }

    public int hashCode() {
        return this.type.hashCode() * this.data.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof BlockDataMock)) return false;
        BlockDataMock mock = (BlockDataMock)obj;
        if (this.getMaterial() != mock.getMaterial()) return false;
        if (!this.data.equals(mock.data)) return false;
        return true;
    }

    @NotNull
    public BlockData clone() {
        try {
            return (BlockData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new BlockDataMock(this.type);
        }
    }

    @NotNull
    public static BlockDataMock mock(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        if (Tag.BEDS.isTagged((Keyed)material)) {
            return new BedMock(material);
        }
        return switch (material) {
            case Material.AMETHYST_CLUSTER -> new AmethystClusterMock(material);
            default -> new BlockDataMock(material);
        };
    }
}

