/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.AmethystCluster;
import org.jetbrains.annotations.NotNull;

public class AmethystClusterMock
extends BlockDataMock
implements AmethystCluster,
Directional,
Waterlogged {
    private static final String FACING = "facing";
    private static final String WATERLOGGED = "waterlogged";

    public AmethystClusterMock(@NotNull Material type) {
        super(type);
        if (type != Material.AMETHYST_CLUSTER) {
            throw new IllegalArgumentException("Cannot create an AmethystClusterMock for " + type.name());
        }
        this.setFacing(BlockFace.NORTH);
        this.setWaterlogged(false);
    }

    @NotNull
    public BlockFace getFacing() {
        return (BlockFace)super.get(FACING);
    }

    public void setFacing(@NotNull BlockFace facing) {
        Preconditions.checkNotNull((Object)facing, (Object)"Facing cannot be null");
        Preconditions.checkArgument((boolean)this.getFaces().contains(facing), (Object)("Invalid face. Must be one of " + this.getFaces()));
        super.set(FACING, facing);
    }

    @NotNull
    public Set<BlockFace> getFaces() {
        return ImmutableSet.of((Object)BlockFace.NORTH, (Object)BlockFace.EAST, (Object)BlockFace.SOUTH, (Object)BlockFace.WEST, (Object)BlockFace.UP, (Object)BlockFace.DOWN, (Object[])new BlockFace[0]);
    }

    public boolean isWaterlogged() {
        return (Boolean)super.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        super.set(WATERLOGGED, waterlogged);
    }
}

