/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeFinishEvent;
import io.papermc.paper.event.world.border.WorldBorderCenterChangeEvent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldBorderMock
implements WorldBorder {
    private static final double DEFAULT_BORDER_SIZE = 6.0E7;
    private static final double DEFAULT_DAMAGE_AMOUNT = 0.2;
    private static final double DEFAULT_DAMAGE_BUFFER = 5.0;
    private static final int DEFAULT_WARNING_DISTANCE = 5;
    private static final int DEFAULT_WARNING_TIME = 15;
    private static final double DEFAULT_CENTER_X = 0.0;
    private static final double DEFAULT_CENTER_Z = 0.0;
    private static final double MAX_CENTER_VALUE = 3.0E7;
    private static final long MAX_MOVEMENT_TIME = 9223372036854775L;
    private static final double MAX_BORDER_SIZE = 6.0E7;
    private static final double MIN_BORDER_SIZE = 1.0;
    private final World world;
    private double size;
    private double damageAmount;
    private double damageBuffer;
    private int warningDistance;
    private int warningTime;
    private double centerX;
    private double centerZ;

    public WorldBorderMock(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        this.world = world;
        this.reset();
    }

    @Nullable
    public World getWorld() {
        return this.world;
    }

    public void reset() {
        this.setSize(6.0E7);
        this.setDamageAmount(0.2);
        this.setDamageBuffer(5.0);
        this.setWarningDistance(5);
        this.setWarningTime(15);
        this.setCenter(0.0, 0.0);
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double newSize) {
        this.setSize(newSize, 0L);
    }

    public void setSize(double newSize, long seconds) {
        newSize = Math.min(6.0E7, Math.max(1.0, newSize));
        WorldBorderBoundsChangeEvent.Type moveType = (seconds = Math.min(9223372036854775L, Math.max(0L, seconds))) <= 0L ? WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE : WorldBorderBoundsChangeEvent.Type.STARTED_MOVE;
        WorldBorderBoundsChangeEvent event = new WorldBorderBoundsChangeEvent(this.world, (WorldBorder)this, moveType, this.size, newSize, seconds * 1000L);
        if (!event.callEvent()) {
            return;
        }
        double millis = event.getDuration();
        newSize = event.getNewSize();
        if (millis <= 0.0) {
            this.size = newSize;
            return;
        }
        double distance = newSize - this.size;
        this.moveBorderOverTime(distance, millis, newSize);
    }

    private void moveBorderOverTime(final double distance, final double millis, final double newSize) {
        final double distancePerTick = distance / (millis / 1000.0 * 20.0);
        final double oldSize = this.size;
        final WorldBorderMock thisBorder = this;
        new BukkitRunnable(){

            public void run() {
                if (WorldBorderMock.this.size < newSize && distance > 0.001 || WorldBorderMock.this.size > newSize && distance < -0.001) {
                    WorldBorderMock.this.size += distancePerTick;
                } else {
                    WorldBorderMock.this.size = newSize;
                    new WorldBorderBoundsChangeFinishEvent(WorldBorderMock.this.world, (WorldBorder)thisBorder, oldSize, newSize, millis).callEvent();
                    this.cancel();
                }
            }
        }.runTaskTimer(null, 1L, 1L);
    }

    @NotNull
    public Location getCenter() {
        return new Location(this.world, this.centerX, 0.0, this.centerZ);
    }

    public void setCenter(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        this.setCenter(location.getX(), location.getZ());
    }

    public void setCenter(double x, double z) {
        WorldBorderCenterChangeEvent event = new WorldBorderCenterChangeEvent(this.world, (WorldBorder)this, new Location(this.world, this.centerX, 0.0, this.centerZ), new Location(this.world, x = Math.min(3.0E7, Math.max(-3.0E7, x)), 0.0, z = Math.min(3.0E7, Math.max(-3.0E7, z))));
        if (!event.callEvent()) {
            return;
        }
        this.centerX = event.getNewCenter().getX();
        this.centerZ = event.getNewCenter().getZ();
    }

    public double getDamageBuffer() {
        return this.damageBuffer;
    }

    public void setDamageBuffer(double blocks) {
        this.damageBuffer = blocks;
    }

    public double getDamageAmount() {
        return this.damageAmount;
    }

    public void setDamageAmount(double damage) {
        this.damageAmount = damage;
    }

    public int getWarningTime() {
        return this.warningTime;
    }

    public void setWarningTime(int seconds) {
        this.warningTime = seconds;
    }

    public int getWarningDistance() {
        return this.warningDistance;
    }

    public void setWarningDistance(int distance) {
        this.warningDistance = distance;
    }

    public boolean isInside(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        BoundingBox worldBorderBoundingBox = new BoundingBox(this.centerX - this.size, Double.MAX_VALUE, this.centerZ - this.size, this.centerX + this.size, -1.7976931348623157E308, this.centerZ + this.size);
        return worldBorderBoundingBox.contains(location.toVector()) && location.getWorld() == this.world;
    }
}

