/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.Coordinate;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;

public class MockChunkData
implements ChunkGenerator.ChunkData {
    private final Map<Coordinate, BlockData> blocks;
    private final Map<Coordinate, Biome> biomes;
    private final Biome defaultBiome;
    private final int minHeight;
    private final int maxHeight;

    public MockChunkData(@NotNull World world) {
        this.minHeight = world.getMinHeight();
        this.maxHeight = world.getMaxHeight();
        this.blocks = new HashMap<Coordinate, BlockData>(225 * Math.abs(world.getMaxHeight() - world.getMinHeight()), 1.0f);
        if (world instanceof WorldMock) {
            WorldMock mockWorld = (WorldMock)world;
            this.biomes = mockWorld.getBiomeMap();
            this.defaultBiome = mockWorld.getDefaultBiome();
        } else {
            this.biomes = new HashMap<Coordinate, Biome>(0);
            this.defaultBiome = Biome.PLAINS;
        }
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    @NotNull
    public Biome getBiome(int x, int y, int z) {
        return this.biomes.getOrDefault(new Coordinate(x, y, z), this.defaultBiome);
    }

    public void setBlock(int x, int y, int z, @NotNull Material material) {
        this.setBlock(x, y, z, new BlockDataMock(material));
    }

    public void setBlock(int x, int y, int z, @NotNull MaterialData material) {
        this.setBlock(x, y, z, new BlockDataMock(material.getItemType()));
    }

    public void setBlock(int x, int y, int z, @NotNull BlockData blockData) {
        this.checkCoords(x, y, z);
        this.blocks.put(new Coordinate(x, y, z), blockData);
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, @NotNull Material material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, new BlockDataMock(material));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, @NotNull MaterialData material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, new BlockDataMock(material.getItemType()));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, @NotNull BlockData blockData) {
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    this.setBlock(x, y, z, blockData);
                }
            }
        }
    }

    @NotNull
    public Material getType(int x, int y, int z) {
        this.checkCoords(x, y, z);
        BlockData data = this.blocks.get(new Coordinate(x, y, z));
        return data == null ? Material.AIR : data.getMaterial();
    }

    @NotNull
    public MaterialData getTypeAndData(int x, int y, int z) {
        return new MaterialData(this.getType(x, y, z));
    }

    @NotNull
    public BlockData getBlockData(int x, int y, int z) {
        this.checkCoords(x, y, z);
        BlockData data = this.blocks.get(new Coordinate(x, y, z));
        return data == null ? new BlockDataMock(Material.AIR) : data;
    }

    public byte getData(int x, int y, int z) {
        return this.getTypeAndData(x, y, z).getData();
    }

    private void checkCoords(int x, int y, int z) {
        Preconditions.checkArgument((x == (x & 0xF) && y >= this.minHeight && y < this.maxHeight && z == (z & 0xF) ? 1 : 0) != 0, (Object)"Coordinates are out-of-bounds");
    }
}

