/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.ChunkSnapshotMock;
import be.seeseemelk.mockbukkit.Coordinate;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ChunkMock
implements Chunk {
    private final World world;
    private final int x;
    private final int z;
    private boolean loaded = true;
    private final PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();

    protected ChunkMock(World world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @NotNull
    public Collection<BlockState> getTileEntities(@NotNull Predicate<Block> blockPredicate, boolean useSnapshot) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockState[] getTileEntities(boolean useSnapshot) {
        throw new UnimplementedOperationException();
    }

    public long getChunkKey() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    @NotNull
    public Block getBlock(int x, int y, int z) {
        Preconditions.checkArgument((0 <= x && x <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x);
        Preconditions.checkArgument((this.world.getMinHeight() <= y && y <= this.world.getMaxHeight() ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)this.world.getMinHeight(), (Object)this.world.getMaxHeight(), (Object)y);
        Preconditions.checkArgument((0 <= z && z <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z);
        return this.world.getBlockAt((this.x << 4) + x, y, (this.z << 4) + z);
    }

    @NotNull
    public Block getBlock(@NotNull Coordinate coordinate) {
        return this.getBlock(coordinate.x, coordinate.y, coordinate.z);
    }

    @NotNull
    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    @NotNull
    public ChunkSnapshot getChunkSnapshot(boolean includeMaxblocky, boolean includeBiome, boolean includeBiomeTempRain) {
        int size = 256 * Math.abs(this.world.getMaxHeight() - this.world.getMinHeight());
        ImmutableMap.Builder blockStates = ImmutableMap.builderWithExpectedSize((int)size);
        ImmutableMap.Builder biomes = ImmutableMap.builderWithExpectedSize((int)size);
        for (int x = 0; x < 15; ++x) {
            for (int y = this.world.getMinHeight(); y < this.world.getMaxHeight(); ++y) {
                for (int z = 0; z < 15; ++z) {
                    Coordinate coord = new Coordinate(x, y, z);
                    blockStates.put((Object)coord, (Object)this.getBlock(x, y, z).getState());
                    if (!includeBiome) continue;
                    biomes.put((Object)coord, (Object)this.world.getBiome(x << 4, y, z << 4));
                }
            }
        }
        return new ChunkSnapshotMock(this.x, this.z, this.world.getMinHeight(), this.world.getMaxHeight(), this.world.getName(), this.world.getFullTime(), (Map<Coordinate, BlockState>)blockStates.build(), (Map<Coordinate, Biome>)biomes.build());
    }

    public boolean isEntitiesLoaded() {
        throw new UnimplementedOperationException();
    }

    public Entity[] getEntities() {
        throw new UnimplementedOperationException();
    }

    public BlockState[] getTileEntities() {
        throw new UnimplementedOperationException();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean load(boolean generate) {
        return this.load();
    }

    public boolean load() {
        this.loaded = true;
        return true;
    }

    public boolean unload(boolean save) {
        return this.unload();
    }

    public boolean unload() {
        this.loaded = false;
        return true;
    }

    public boolean isSlimeChunk() {
        throw new UnimplementedOperationException();
    }

    public int hashCode() {
        return this.world.hashCode() + this.x + this.z;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ChunkMock) {
            ChunkMock chunk = (ChunkMock)obj;
            return this.x == chunk.x && this.z == chunk.z && this.world.equals(chunk.world);
        }
        return false;
    }

    public boolean isForceLoaded() {
        throw new UnimplementedOperationException();
    }

    public void setForceLoaded(boolean forced) {
        throw new UnimplementedOperationException();
    }

    public boolean addPluginChunkTicket(@NotNull Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    public boolean removePluginChunkTicket(@NotNull Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Plugin> getPluginChunkTickets() {
        throw new UnimplementedOperationException();
    }

    public long getInhabitedTime() {
        throw new UnimplementedOperationException();
    }

    public void setInhabitedTime(long ticks) {
        throw new UnimplementedOperationException();
    }

    public boolean contains(@NotNull BlockData block) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }
}

