package com.github.scalafanatic
package scalaalgorithms

/**
  * Solves the Josephus problem for an arbitrary integer number of people and an arbitrary integer
  * "skip distance" - i.e. the number of people to count off before killing the next. The return
  * value of this function uses a one-based index; e.g. if we return 7, then the 7th person
  * will be safe.
  *
  * Reference: [[https://en.wikipedia.org/wiki/Josephus_problem]]
  */
object Josephus {
  def find(personCount: Int, skip: Int): Int =
    if (personCount <= 1 || skip <= 0) 1
    else if (skip == 1) personCount // The last person
    else {
      var result = 0
      (1 to personCount).foreach { i =>
        result = (result + skip) % i
      }
      result + 1
    }
}
