package com.github.scalafanatic
package scalaalgorithms

object FindRepeatingStrings {
  /**
    * Finds all sequences of characters that repeat at least once consecutively in the given string.
    */
  def findAll(string: String): IndexedSeq[String] =
    string.indices
      .flatMap { i =>
        (i + 1 until string.length).map { j =>
          val current = string.slice(i, j)
          if (j + current.length <= string.length && string.slice(j, j + current.length) == current)
            Some(current)
          else None
        }
      }
      .collect { case Some(s) => s }
      .distinct // This is a linear-time operation
}
