package com.github.scalafanatic
package scalaalgorithms

import scala.collection.immutable.HashSet

object PowerSet {
  /**
    * Generates the power set of a given set of numbers.
    *
    * Reference: [[https://en.wikipedia.org/wiki/Power_set]]
    */
  def generateFrom(set: HashSet[Int]): HashSet[HashSet[Int]] = {
    val lookup = set.toArray // One-time upfront cost for efficient lookups/indexing
    var powerSet = HashSet.empty[HashSet[Int]]
    def helper(current: HashSet[Int], index: Int): Unit = {
      if (index == set.size) {
        powerSet = powerSet + current
      } else {
        // We have two choices at every index of the input set: 1) add the current item or 2) do not
        // add it. Creating a power set simply involves making BOTH choices.
        helper(current, index + 1)
        helper(current + lookup(index), index + 1)
      }
    }
    helper(HashSet.empty, 0)
    powerSet
  }
}
