package com.github.scalafanatic
package scalaalgorithms

object FloodFill {
  /**
    * Returns the size of the largest contiguous "landmass" (1 = land, 0 = water) in the input
    * matrix. Note that this Flood Fill implementation is 4-directional, and it will mutate its
    * argument.
    *
    * Reference: [[https://en.wikipedia.org/wiki/Flood_fill]]
    */
  def execute(matrix: Array[Array[Int]]): Int = {
    def helper(row: Int, column: Int): Int =
      if (
        row < 0 || column < 0 || row >= matrix.length || column >= matrix(row).length ||
        matrix(row)(column) == 0
      ) 0 // Base case
      else {
        matrix(row)(column) = 0 // If we do not do this, we will recurse infinitely!
        1 + helper(row - 1, column) + helper(row, column - 1) + helper(row + 1, column) +
          helper(row, column + 1)
      }
    var largest = 0
    for (row <- matrix.indices; column <- matrix(row).indices) {
      largest = Math.max(largest, helper(row, column))
    }
    largest
  }
}
