/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.site.gitbook;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.sbt.site.Compat$;
import com.typesafe.sbt.site.SitePlugin;
import com.typesafe.sbt.site.SitePlugin$;
import com.typesafe.sbt.site.gitbook.GitBookPlugin$autoImport$;
import com.typesafe.sbt.site.util.SiteHelpers$;
import java.io.File;
import java.io.Serializable;
import sbt.AutoPlugin;
import sbt.Def$;
import sbt.Keys$;
import sbt.PluginTrigger;
import sbt.Scoped;
import sbt.SettingKey;
import sbt.internal.util.AList$;
import sbt.internal.util.Init;
import sbt.internal.util.LinePosition;
import sbt.internal.util.SourcePosition;
import sbt.io.FileFilter;
import sbt.io.PathFinder;
import sbt.io.RichFile$;
import sbt.librarymanagement.Configuration;
import sbt.package$;
import sbt.std.FullInstance$;
import sbt.std.InitializeInstance$;
import sbt.std.TaskStreams;
import sbt.util.Logger;
import sbt.util.Logger$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class GitBookPlugin$
extends AutoPlugin {
    public static GitBookPlugin$ MODULE$;

    static {
        new GitBookPlugin$();
    }

    public SitePlugin$ requires() {
        return SitePlugin$.MODULE$;
    }

    public PluginTrigger trigger() {
        return this.noTrigger();
    }

    public Seq<Init.Setting<?>> projectSettings() {
        return this.gitbookSettings(GitBookPlugin$autoImport$.MODULE$.GitBook());
    }

    public Seq<Init.Setting<?>> gitbookSettings(Configuration config) {
        return (Seq)((TraversableLike)((TraversableLike)package$.MODULE$.inConfig(config, (Seq)new .colon.colon((Object)Keys$.MODULE$.includeFilter().set(InitializeInstance$.MODULE$.pure((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.AllPassFilter()), (SourcePosition)new LinePosition("(com.typesafe.sbt.site.gitbook.GitBookPlugin.gitbookSettings) GitBookPlugin.scala", 29)), (List)new .colon.colon((Object)Keys$.MODULE$.excludeFilter().set(InitializeInstance$.MODULE$.pure((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.HiddenFileFilter()), (SourcePosition)new LinePosition("(com.typesafe.sbt.site.gitbook.GitBookPlugin.gitbookSettings) GitBookPlugin.scala", 30)), (List)new .colon.colon((Object)GitBookPlugin$autoImport$.MODULE$.gitbookInstallDir().set((Init.Initialize)FullInstance$.MODULE$.pure((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$), (SourcePosition)new LinePosition("(com.typesafe.sbt.site.gitbook.GitBookPlugin.gitbookSettings) GitBookPlugin.scala", 31)), (List)new .colon.colon((Object)Keys$.MODULE$.mappings().set((Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple6((Object)Keys$.MODULE$.streams(), GitBookPlugin$autoImport$.MODULE$.gitbookInstallDir(), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.excludeFilter()), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.includeFilter()), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.target()), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.sourceDirectory())), (Function1 & Serializable & scala.Serializable)$p$macro$7 -> {
            TaskStreams taskStreams = (TaskStreams)$p$macro$7._1();
            Option option = (Option)$p$macro$7._2();
            FileFilter fileFilter = (FileFilter)$p$macro$7._3();
            FileFilter fileFilter2 = (FileFilter)$p$macro$7._4();
            File file = (File)$p$macro$7._5();
            File file2 = (File)$p$macro$7._6();
            return MODULE$.generate(file2, file, fileFilter2, fileFilter, (Option<File>)option, taskStreams);
        }, AList$.MODULE$.tuple6()), (SourcePosition)new LinePosition("(com.typesafe.sbt.site.gitbook.GitBookPlugin.gitbookSettings) GitBookPlugin.scala", 32)), (List)new .colon.colon((Object)SitePlugin.autoImport$.MODULE$.siteSubdirName().set(InitializeInstance$.MODULE$.pure((Function0 & Serializable & scala.Serializable)() -> ""), (SourcePosition)new LinePosition("(com.typesafe.sbt.site.gitbook.GitBookPlugin.gitbookSettings) GitBookPlugin.scala", 40)), (List)Nil$.MODULE$)))))).$plus$plus((GenTraversableOnce)SiteHelpers$.MODULE$.directorySettings(config), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)SiteHelpers$.MODULE$.watchSettings(config), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Def$.MODULE$.SettingsDefinition().unwrapSettingsDefinition((Init.SettingsDefinition)SiteHelpers$.MODULE$.addMappingsToSiteDir((Init.Initialize)package$.MODULE$.sbtSlashSyntaxRichConfiguration(config).$div((Scoped.ScopingSetting)Keys$.MODULE$.mappings()), (SettingKey)package$.MODULE$.sbtSlashSyntaxRichConfiguration(config).$div((Scoped.ScopingSetting)SitePlugin.autoImport$.MODULE$.siteSubdirName()))), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<File, String>> generate(File src, File target, FileFilter inc, FileFilter exc, Option<File> installDir2, TaskStreams<Init.ScopedKey<?>> s) {
        Seq runEnv = Option$.MODULE$.option2Iterable(installDir2.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HOME"), (Object)x$1.getAbsolutePath()))).toSeq();
        String gitbook = (String)installDir2.map((Function1 & Serializable & scala.Serializable)installDir -> GitBookPlugin$.install$1(installDir, src, runEnv, s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "gitbook");
        Option<File> option = this.outputDir(src);
        if (option instanceof Some) {
            Some some = (Some)option;
            File output = (File)some.value();
            GitBookPlugin$.run$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{gitbook, "build"}), src, runEnv, s);
            String string = output.getCanonicalPath();
            String string2 = target.getCanonicalPath();
            if (string == null ? string2 != null : !string.equals(string2)) {
                s.log().warn((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(249).append("|The output directory in book.json resolves to ").append(output).append("\n                |which does not match the target ").append(target).append(".\n                |We are going to copy the files over, but you might want to remove\n                |the 'output' setting in ").append(MODULE$.bookJson(src)).append(" so the clean task cleans.").toString())).stripMargin());
                package$.MODULE$.IO().copyDirectory(output, target, true, true, package$.MODULE$.IO().copyDirectory$default$5());
            }
        } else if (None$.MODULE$.equals(option)) {
            GitBookPlugin$.run$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{gitbook, "build", src.getAbsolutePath(), target.getCanonicalPath()}), src, runEnv, s);
        } else {
            throw new MatchError(option);
        }
        PathFinder files = package$.MODULE$.singleFileFinder(target).$times$times(inc).$minus$minus$minus(package$.MODULE$.singleFileFinder(target).$times$times(exc)).$minus$minus$minus(package$.MODULE$.singleFileFinder(target));
        return files.pair(package$.MODULE$.Path().relativeTo(target), files.pair$default$2());
    }

    public File bookJson(File src) {
        return RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(src), "book.json");
    }

    public Option<File> outputDir(File src) {
        Some some;
        int v;
        Config bookConfig = ConfigFactory.parseFile((File)this.bookJson(src));
        Option version = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bookConfig.getString("gitbook").split("[.]"))).head())).toInt()).toOption();
        String output = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> bookConfig.getString("output")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "_book");
        Option option = version;
        if (option instanceof Some && (v = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) >= 3) {
            return None$.MODULE$;
        }
        return new Some((Object)package$.MODULE$.IO().resolve(src, package$.MODULE$.file(output)));
    }

    private static final void run$1(Seq cmd, File src$1, Seq runEnv$1, TaskStreams s$1) {
        int n = Compat$.MODULE$.Process().apply(cmd.toSeq(), (Option)new Some((Object)src$1), runEnv$1).$bang(Logger$.MODULE$.log2PLog((Logger)s$1.log()));
        switch (n) {
            case 0: {
                return;
            }
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(25).append("Could not run `").append(cmd.mkString(" ")).append("`, error: ").append(n).toString());
    }

    private static final String install$1(File installDir, File src$1, Seq runEnv$1, TaskStreams s$1) {
        if (!installDir.exists()) {
            package$.MODULE$.IO().write(RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(installDir), ".gitignore"), "*", package$.MODULE$.IO().write$default$3(), package$.MODULE$.IO().write$default$4());
            package$.MODULE$.IO().write(RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(installDir), ".gitconfig"), new StringOps(Predef$.MODULE$.augmentString("|# Enables installation from networks where git:// access is blocked\n             |[url \"https://github.com/\"]\n             |  insteadOf = git://github.com/\n             |")).stripMargin(), package$.MODULE$.IO().write$default$3(), package$.MODULE$.IO().write$default$4());
        }
        String installPath = installDir.getAbsolutePath();
        String gitbookPath = new StringBuilder(12).append(installPath).append("/bin/gitbook").toString();
        GitBookPlugin$.run$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"npm", "install", "-g", "--prefix", installPath, "gitbook-cli"}), src$1, runEnv$1, s$1);
        GitBookPlugin$.run$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{gitbookPath, "install"}), src$1, runEnv$1, s$1);
        return gitbookPath;
    }

    private GitBookPlugin$() {
        MODULE$ = this;
    }
}

